/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.IProjectFileNamingStrategy;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.User;
import edu.kit.kastel.eclipse.common.api.controller.AbstractController;
import edu.kit.kastel.eclipse.common.api.controller.IExerciseArtemisController;
import edu.kit.kastel.eclipse.common.api.controller.IViewInteraction;
import edu.kit.kastel.eclipse.common.client.git.GitCredentials;
import edu.kit.kastel.eclipse.common.client.git.GitException;
import edu.kit.kastel.eclipse.common.client.git.GitHandler;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;

public class ExerciseArtemisController
extends AbstractController
implements IExerciseArtemisController {
    private String username;
    private String gitPassword;

    public ExerciseArtemisController(IViewInteraction viewInteractionHandler, User user, IPreferenceStore preferenceStore) {
        super(viewInteractionHandler);
        this.username = user == null ? null : user.getLogin();
        String password = preferenceStore.getString("artemisPassword");
        String gitToken = preferenceStore.getString("gitToken");
        this.gitPassword = gitToken != null && !gitToken.isBlank() ? gitToken : (password != null && !password.isBlank() ? password : (user != null && user.getVcsAccessToken() != null ? user.getVcsAccessToken() : ""));
    }

    public void downloadExerciseAndSubmission(IExercise exercise, ISubmission submission, File dir, IProjectFileNamingStrategy namingStrategy) throws ArtemisClientException {
        File projectDirectory = namingStrategy.getProjectFileInWorkspace(dir, exercise, submission);
        this.existsAndThrow(projectDirectory);
        try {
            if (projectDirectory.exists()) {
                throw new ArtemisClientException("Could not clone project " + projectDirectory.getName() + ", " + "directory already exists!");
            }
            GitCredentials credentials = new GitCredentials(this.username, this.gitPassword);
            GitHandler.cloneRepo((File)projectDirectory, (String)exercise.getTestRepositoryUrl(), (GitCredentials)credentials);
            GitHandler.cloneRepo((File)namingStrategy.getAssignmentFileInProjectDirectory(projectDirectory), (String)submission.getRepositoryUrl(), (GitCredentials)credentials);
        }
        catch (GitException e) {
            throw new ArtemisClientException("Unable to download exercise and submission: " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && (files = directory.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    ExerciseArtemisController.deleteDirectory(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        return directory.delete();
    }

    private void existsAndThrow(File file) throws ArtemisClientException {
        if (file.exists()) {
            throw new ArtemisClientException("Project " + file.getName() + " could not be cloned since the workspace " + "already contains a project with that name. \n" + "Trying to load and merge previously created annotations. Please double-check them before submitting the assessment! \n" + "If you want to start again from skretch, please delete the project and retry.");
        }
    }
}

