/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.ILockResult;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ICourse;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.controller.ExerciseStats;
import edu.kit.kastel.eclipse.common.api.controller.IAssessmentController;
import edu.kit.kastel.eclipse.common.api.controller.IGradingArtemisController;
import edu.kit.kastel.eclipse.common.api.controller.IViewInteraction;
import edu.kit.kastel.eclipse.common.core.ArtemisController;
import edu.kit.kastel.eclipse.common.core.artemis.AnnotationMapper;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class GradingArtemisController
extends ArtemisController
implements IGradingArtemisController {
    public GradingArtemisController(String host, String username, String password, IViewInteraction handler) {
        super(host, username, password, handler);
    }

    public List<String> getExerciseShortNamesFromExam(String examTitle) {
        return this.getExercisesFromExam(examTitle).stream().map(IExercise::getShortName).toList();
    }

    @Override
    protected List<ICourse> fetchCourses() {
        if (!this.clientManager.isReady()) {
            return List.of();
        }
        try {
            return this.clientManager.getCourseArtemisClient().getCoursesForAssessment();
        }
        catch (ArtemisClientException e) {
            this.error(e.getMessage(), e);
            return List.of();
        }
    }

    public boolean saveAssessment(IAssessmentController assessmentController, IExercise exercise, ISubmission submission, boolean submit) {
        if (!this.lockResults.containsKey(submission.getSubmissionId())) {
            throw new IllegalStateException("Assessment not started, yet!");
        }
        ILockResult lock = (ILockResult)this.lockResults.get(submission.getSubmissionId());
        int participationId = lock.getParticipationId();
        List annotations = assessmentController.getAnnotations();
        List ratingGroups = assessmentController.getRatingGroups();
        try {
            AnnotationMapper mapper = new AnnotationMapper(exercise, submission, annotations, ratingGroups, this.clientManager.getAuthenticationClient().getUser(), lock);
            this.clientManager.getAssessmentArtemisClient().saveAssessment(participationId, submit, mapper.createAssessmentResult());
        }
        catch (IOException e) {
            this.error("Local backend failed to format the annotations: " + e.getMessage(), e);
            return false;
        }
        catch (ArtemisClientException e) {
            this.error("Assessor could not be retrieved from Artemis or Authentication to Artemis failed:" + e.getMessage(), e);
            return false;
        }
        if (submit) {
            this.lockResults.remove(submission.getSubmissionId());
        }
        return true;
    }

    public void startAssessment(ISubmission submissionId) {
        try {
            this.lockResults.put(submissionId.getSubmissionId(), this.clientManager.getAssessmentArtemisClient().startAssessment(submissionId));
        }
        catch (ArtemisClientException e) {
            this.error("Assessment could not be started: " + e.getMessage(), e);
        }
    }

    public Optional<ISubmission> startNextAssessment(IExercise exercise, int correctionRound) {
        Optional lockResultOptional;
        try {
            lockResultOptional = this.clientManager.getAssessmentArtemisClient().startNextAssessment(exercise, correctionRound);
        }
        catch (ArtemisClientException e) {
            this.error("Assessment could not be started: " + e.getMessage(), e);
            return Optional.empty();
        }
        if (lockResultOptional.isEmpty()) {
            return Optional.empty();
        }
        ILockResult lockResult = (ILockResult)lockResultOptional.get();
        int submissionID = lockResult.getSubmissionId();
        this.lockResults.put(submissionID, lockResult);
        try {
            return Optional.of(exercise.getSubmission(submissionID));
        }
        catch (ArtemisClientException e) {
            this.error("Assessment could not be started: " + e.getMessage(), e);
            return Optional.empty();
        }
    }

    public ExerciseStats getStats(IExercise exercise) throws ArtemisClientException {
        return this.clientManager.getAssessmentArtemisClient().getStats(exercise);
    }
}

