/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.IProjectFileNamingStrategy;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ICourse;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExam;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.controller.ExerciseStats;
import edu.kit.kastel.eclipse.common.api.controller.IArtemisController;
import edu.kit.kastel.eclipse.common.api.controller.IAssessmentController;
import edu.kit.kastel.eclipse.common.api.controller.IGradingArtemisController;
import edu.kit.kastel.eclipse.common.api.controller.IGradingSystemwideController;
import edu.kit.kastel.eclipse.common.api.controller.ISubmissionLifecycleCallback;
import edu.kit.kastel.eclipse.common.api.controller.IViewInteraction;
import edu.kit.kastel.eclipse.common.core.AssessmentController;
import edu.kit.kastel.eclipse.common.core.GradingArtemisController;
import edu.kit.kastel.eclipse.common.core.SystemwideController;
import edu.kit.kastel.eclipse.common.core.artemis.WorkspaceUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;

public class GradingSystemwideController
extends SystemwideController
implements IGradingSystemwideController {
    private final Map<Integer, IAssessmentController> assessmentControllers = new HashMap<Integer, IAssessmentController>();
    private IGradingArtemisController artemisController;
    private ISubmission submission;

    public GradingSystemwideController(IPreferenceStore preferenceStore, IViewInteraction handler) {
        super(preferenceStore, handler);
        this.preferenceStore = preferenceStore;
    }

    @Override
    protected IArtemisController createController(IPreferenceStore preferenceStore, IViewInteraction handler) {
        this.artemisController = new GradingArtemisController(preferenceStore.getString("artemisUrl"), preferenceStore.getString("artemisUser"), preferenceStore.getString("artemisPassword"), handler);
        return this.artemisController;
    }

    private IAssessmentController getAssessmentController(ISubmission submission, ICourse course, IExercise exercise) {
        this.assessmentControllers.computeIfAbsent(submission.getSubmissionId(), submissionIDParam -> new AssessmentController(this, course, exercise, submission));
        return this.assessmentControllers.get(submission.getSubmissionId());
    }

    private List<ISubmission> getBegunSubmissions() {
        if (this.nullCheckMembersAndNotify(true, true, false)) {
            return List.of();
        }
        return this.getArtemisController().getBegunSubmissions(this.exercise);
    }

    public ExerciseStats getStats() {
        if (this.nullCheckMembersAndNotify(true, true, false)) {
            return new ExerciseStats(0, 0, 0, 0);
        }
        try {
            return this.getArtemisController().getStats(this.exercise);
        }
        catch (ArtemisClientException e) {
            this.error(e.getMessage(), e);
            return new ExerciseStats(0, 0, 0, 0);
        }
    }

    public List<String> getBegunSubmissionsProjectNames() {
        if (this.course == null || this.exercise == null) {
            this.info("You need to choose a" + (this.course == null ? "course" : "") + (this.course == null && this.exercise == null ? " and an " : "") + (this.exercise == null ? "exercise" : "."));
            return List.of();
        }
        return this.getBegunSubmissions().stream().map(sub -> this.projectFileNamingStrategy.getProjectFileInWorkspace(WorkspaceUtil.getWorkspaceFile(), this.getCurrentExercise(), sub).getName()).sorted().toList();
    }

    public IAssessmentController getCurrentAssessmentController() {
        if (this.nullCheckMembersAndNotify(true, true, true)) {
            return null;
        }
        return this.getAssessmentController(this.submission, this.course, this.exercise);
    }

    private IExercise getCurrentExercise() {
        if (this.nullCheckMembersAndNotify(true, true, false)) {
            return null;
        }
        return this.exercise;
    }

    public String getCurrentProjectName() {
        if (this.nullCheckMembersAndNotify(true, true, true)) {
            return null;
        }
        return this.projectFileNamingStrategy.getProjectFileInWorkspace(WorkspaceUtil.getWorkspaceFile(), this.getCurrentExercise(), this.getCurrentSubmission()).getName();
    }

    private ISubmission getCurrentSubmission() {
        if (this.nullCheckMembersAndNotify(true, true, true)) {
            return null;
        }
        return this.submission;
    }

    public void loadAgain() {
        if (this.nullCheckMembersAndNotify(true, true, true)) {
            return;
        }
        this.artemisController.startAssessment(this.submission);
        this.downloadExerciseAndSubmission(this.course, this.exercise, this.submission, this.projectFileNamingStrategy);
    }

    public void setExerciseId(String exerciseShortName) throws ArtemisClientException {
        ArrayList exercises = new ArrayList(this.course.getExercises());
        for (IExam ex : this.course.getExams()) {
            ex.getExerciseGroups().forEach(g -> {
                boolean bl = exercises.addAll(g.getExercises());
            });
        }
        for (IExam ex : exercises) {
            if (!ex.getShortName().equals(exerciseShortName)) continue;
            this.exercise = ex;
            return;
        }
        this.error("No Exercise with the given shortName \"" + exerciseShortName + "\" found.", null);
    }

    public void reloadAssessment() {
        if (this.nullCheckMembersAndNotify(true, true, true)) {
            return;
        }
        this.getCurrentAssessmentController().resetAndRestartAssessment(this.projectFileNamingStrategy);
    }

    public void saveAssessment() {
        if (this.nullCheckMembersAndNotify(true, true, true)) {
            return;
        }
        this.artemisController.saveAssessment(this.getCurrentAssessmentController(), this.exercise, this.submission, false);
    }

    public void setAssessedSubmissionByProjectName(String projectName) {
        for (ISubmission submission : this.getBegunSubmissions()) {
            String currentProjectName = this.projectFileNamingStrategy.getProjectFileInWorkspace(WorkspaceUtil.getWorkspaceFile(), this.getCurrentExercise(), submission).getName();
            if (!currentProjectName.equals(projectName)) continue;
            this.submission = submission;
            return;
        }
        this.error("Assessed submission with projectName=\"" + projectName + "\" not found!", null);
    }

    public List<String> setCourseIdAndGetExerciseShortNames(String courseShortName) throws ArtemisClientException {
        for (ICourse c : this.getArtemisController().getCourses()) {
            if (!c.getShortName().equals(courseShortName)) continue;
            this.course = c;
            return c.getExercises().stream().filter(it -> !it.isAutomaticAssessment()).map(IExercise::getShortName).toList();
        }
        this.error("No Course with the given shortName \"" + courseShortName + "\" found.", null);
        return List.of();
    }

    private boolean startAssessment(int correctionRound) {
        if (this.nullCheckMembersAndNotify(true, true, false)) {
            return false;
        }
        Optional optionalSubmission = this.artemisController.startNextAssessment(this.exercise, correctionRound);
        if (optionalSubmission.isEmpty()) {
            this.info("No more submissions available for Correction Round " + (correctionRound + 1) + "!");
            return false;
        }
        this.submission = (ISubmission)optionalSubmission.get();
        return this.downloadExerciseAndSubmission(this.course, this.exercise, this.submission, this.projectFileNamingStrategy);
    }

    public boolean startCorrectionRound1() {
        return this.startAssessment(0);
    }

    public boolean startCorrectionRound2() {
        return this.startAssessment(1);
    }

    public void submitAssessment() {
        if (this.nullCheckMembersAndNotify(true, true, true)) {
            return;
        }
        if (this.artemisController.saveAssessment(this.getCurrentAssessmentController(), this.exercise, this.submission, true)) {
            this.closeAssessment();
        }
    }

    public void closeAssessment() {
        if (this.nullCheckMembersAndNotify(true, true, true)) {
            return;
        }
        this.getCurrentAssessmentController().deleteEclipseProject(this.projectFileNamingStrategy);
        this.assessmentControllers.remove(this.submission.getSubmissionId());
        this.submission = null;
    }

    private boolean nullCheckMembersAndNotify(boolean checkCourseId, boolean checkExerciseId, boolean checkSubmissionId) {
        boolean somethingNull = this.nullCheckMembersAndNotify(checkCourseId, checkExerciseId);
        if (checkSubmissionId && this.submission == null) {
            this.warn("Submission is not set ");
            somethingNull = true;
        }
        return somethingNull;
    }

    @Override
    protected void refreshArtemisController(IPreferenceStore preferenceStore) {
        this.createController(preferenceStore, this.getViewInteractionHandler());
    }

    public boolean downloadExerciseAndSubmission(ICourse course, IExercise exercise, ISubmission submission, IProjectFileNamingStrategy projectNaming) {
        File eclipseWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        try {
            this.exerciseController.downloadExerciseAndSubmission(exercise, submission, eclipseWorkspaceRoot, projectNaming);
        }
        catch (ArtemisClientException e) {
            this.error(e.getMessage(), e);
            return false;
        }
        try {
            WorkspaceUtil.createEclipseProject(projectNaming.getProjectFileInWorkspace(eclipseWorkspaceRoot, exercise, submission), (List<ISubmissionLifecycleCallback>)this.buildCompletedCallbacks);
        }
        catch (CoreException e) {
            this.error("Project could not be created: " + e.getMessage(), null);
        }
        return true;
    }

    public IGradingArtemisController getArtemisController() {
        return this.artemisController;
    }

    public boolean isAssessmentStarted() {
        return this.submission != null;
    }

    public Optional<IExercise> getSelectedExercise() {
        return Optional.ofNullable(this.exercise);
    }

    public final IPreferenceStore getPreferences() {
        return this.preferenceStore;
    }

    public Path getCurrentProjectPath() {
        return this.projectFileNamingStrategy.getProjectFileInWorkspace(WorkspaceUtil.getWorkspaceFile(), this.exercise, this.submission).toPath();
    }
}

