/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core;

import edu.kit.kastel.eclipse.common.api.artemis.IProjectFileNamingStrategy;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ICourse;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.controller.AbstractController;
import edu.kit.kastel.eclipse.common.api.controller.IArtemisController;
import edu.kit.kastel.eclipse.common.api.controller.IExerciseArtemisController;
import edu.kit.kastel.eclipse.common.api.controller.ISubmissionLifecycleCallback;
import edu.kit.kastel.eclipse.common.api.controller.ISystemwideController;
import edu.kit.kastel.eclipse.common.api.controller.IViewInteraction;
import edu.kit.kastel.eclipse.common.core.ExerciseArtemisController;
import edu.kit.kastel.eclipse.common.core.artemis.naming.ProjectFileNamingStrategies;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class SystemwideController
extends AbstractController
implements ISystemwideController {
    protected final List<ISubmissionLifecycleCallback> buildCompletedCallbacks = new ArrayList<ISubmissionLifecycleCallback>();
    protected ICourse course;
    protected IExercise exercise;
    protected IPreferenceStore preferenceStore;
    protected IProjectFileNamingStrategy projectFileNamingStrategy = ProjectFileNamingStrategies.DEFAULT.get();
    protected IExerciseArtemisController exerciseController;

    protected SystemwideController(IPreferenceStore preferenceStore, IViewInteraction handler) {
        super(handler);
        IArtemisController loginController = this.createController(preferenceStore, handler);
        this.exerciseController = new ExerciseArtemisController(handler, loginController.getUserLogin(), preferenceStore);
    }

    protected abstract IArtemisController createController(IPreferenceStore var1, IViewInteraction var2);

    protected abstract void refreshArtemisController(IPreferenceStore var1);

    protected boolean nullCheckMembersAndNotify(boolean checkCourseId, boolean checkExerciseId) {
        String alert = "[";
        boolean somethingNull = false;
        if (checkCourseId && this.course == null) {
            alert = String.valueOf(alert) + "Course is not set ";
            somethingNull = true;
        }
        if (checkExerciseId && this.exercise == null) {
            alert = String.valueOf(alert) + "Exercise is not set ";
            somethingNull = true;
        }
        if (somethingNull) {
            alert = String.valueOf(alert) + "]";
            this.warn(alert);
        }
        return somethingNull;
    }

    public void addSubmissionBuildListener(ISubmissionLifecycleCallback callback) {
        this.buildCompletedCallbacks.add(callback);
    }
}

