/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.artemis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.Feedback;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.core.model.annotation.Annotation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;

public class AnnotationDeserializer {
    private static final ILog log = Platform.getLog(AnnotationDeserializer.class);
    private static final String FEEDBACK_TEXT = "CLIENT_DATA";
    private final Map<String, IMistakeType> mistakeTypesMap;
    private final ObjectMapper oom = new ObjectMapper();

    public AnnotationDeserializer(List<IMistakeType> mistakeTypes) {
        this.mistakeTypesMap = new HashMap<String, IMistakeType>();
        mistakeTypes.forEach(mistakeType -> {
            IMistakeType iMistakeType = this.mistakeTypesMap.put(mistakeType.getIdentifier(), (IMistakeType)mistakeType);
        });
    }

    public List<IAnnotation> deserialize(List<Feedback> feedbacks) throws IOException {
        List<Feedback> feedbacksWithAnnotationInformation = feedbacks.stream().filter(it -> it != null).filter(it -> FEEDBACK_TEXT.equals(it.getText())).toList();
        List<Annotation> annotations = this.readAnnotations(feedbacksWithAnnotationInformation);
        for (Annotation annotation : annotations) {
            String mistakeTypeName = annotation.getMistakeTypeId();
            if (!this.mistakeTypesMap.containsKey(mistakeTypeName)) {
                throw new IOException("Trying to deserialize MistakeType \"" + mistakeTypeName + "\". It was not found in local config!");
            }
            annotation.setMistakeType(this.mistakeTypesMap.get(mistakeTypeName));
        }
        return new ArrayList<IAnnotation>(annotations);
    }

    private List<Annotation> readAnnotations(List<Feedback> feedbacksWithAnnotationInformation) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Feedback feedback : feedbacksWithAnnotationInformation) {
            try {
                List annotationsInFeedback = (List)this.oom.readValue(feedback.getDetailText(), (TypeReference)new TypeReference<List<Annotation>>(){});
                annotations.addAll(annotationsInFeedback);
            }
            catch (JsonProcessingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return annotations;
    }
}

