/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.config;

import com.fasterxml.jackson.databind.util.StdConverter;
import edu.kit.kastel.eclipse.common.core.config.ExerciseConfig;
import edu.kit.kastel.eclipse.common.core.config.ExerciseConfigConverterException;
import edu.kit.kastel.eclipse.common.core.model.MistakeType;
import edu.kit.kastel.eclipse.common.core.model.RatingGroup;
import java.util.List;
import java.util.Optional;

public final class ExerciseConfigConverter
extends StdConverter<ExerciseConfig, ExerciseConfig> {
    public ExerciseConfig convert(ExerciseConfig exerciseConfig) throws ExerciseConfigConverterException {
        List<RatingGroup> ratingGroups = exerciseConfig.getRatingGroups();
        for (MistakeType mistakeType : exerciseConfig.getMistakeTypes()) {
            Optional<RatingGroup> ratingGroupOptional = ratingGroups.stream().filter(ratingGroup -> ratingGroup.getIdentifier().equals(mistakeType.getAppliesTo())).findFirst();
            if (ratingGroupOptional.isEmpty()) {
                throw new ExerciseConfigConverterException("No RatingGroup could be associated with MistakeType " + mistakeType.getIdentifier() + " with appliesTo := " + mistakeType.getAppliesTo() + " and available RatingGroups := " + ratingGroups);
            }
            RatingGroup ratingGroup2 = ratingGroupOptional.get();
            mistakeType.setRatingGroup(ratingGroup2);
            ratingGroup2.addMistakeType(mistakeType);
        }
        return exerciseConfig;
    }
}

