/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.core.config.ExerciseConfig;
import edu.kit.kastel.eclipse.common.core.config.ExerciseConfigConverterException;
import edu.kit.kastel.eclipse.common.core.config.GradingDAO;
import java.io.File;
import java.io.IOException;

public class JsonFileConfigDAO
implements GradingDAO {
    private ExerciseConfig exerciseConfig;
    private final File configFile;
    private final ObjectMapper oom = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public JsonFileConfigDAO(File configFile) {
        this.configFile = configFile;
    }

    @Override
    public ExerciseConfig getExerciseConfig(IExercise exercise) throws IOException, ExerciseConfigConverterException {
        if (this.exerciseConfig == null) {
            this.parse();
        }
        this.exerciseConfig.initialize(exercise);
        return this.exerciseConfig;
    }

    private void parse() throws IOException, ExerciseConfigConverterException {
        this.exerciseConfig = (ExerciseConfig)this.oom.readValue(this.configFile, ExerciseConfig.class);
    }
}

