/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.api.model.IRatingGroup;
import edu.kit.kastel.eclipse.common.core.model.RatingGroup;
import edu.kit.kastel.eclipse.common.core.model.rule.PenaltyRule;
import edu.kit.kastel.eclipse.common.core.model.rule.ThresholdPenaltyRule;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MistakeType
implements IMistakeType {
    @JsonProperty(value="shortName")
    private String identifier;
    @JsonProperty(value="button")
    private String buttonText;
    @JsonProperty(value="additionalButtonTexts")
    private Map<String, String> additionalButtonTexts;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="additionalMessages")
    private Map<String, String> additionalMessages;
    @JsonProperty(value="appliesTo")
    private String appliesTo;
    private RatingGroup ratingGroup;
    @JsonProperty(value="penaltyRule")
    private PenaltyRule penaltyRule;
    @JsonProperty(value="enabledForExercises")
    private String enabledForExercises;
    @JsonProperty(value="enabledPenaltyForExercises")
    private String enabledPenaltyForExercises;
    private transient IExercise currentExercise = null;

    public double calculate(List<IAnnotation> annotations) {
        assert (annotations.stream().allMatch(a -> this.equals(a.getMistakeType())));
        return this.getPenaltyRule().calculate(annotations);
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    public String getMessage(String languageKey) {
        if (languageKey == null || this.additionalMessages == null || !this.additionalMessages.containsKey(languageKey)) {
            return this.message;
        }
        return this.additionalMessages.get(languageKey);
    }

    public String getButtonText(String languageKey) {
        if (languageKey == null || this.additionalButtonTexts == null || !this.additionalButtonTexts.containsKey(languageKey)) {
            return this.buttonText;
        }
        return this.additionalButtonTexts.get(languageKey);
    }

    public void initialize(IExercise exercise) {
        this.currentExercise = exercise;
    }

    public boolean isEnabledMistakeType() {
        if (this.enabledForExercises == null || this.currentExercise == null) {
            return true;
        }
        return this.currentExercise.getShortName().matches(this.enabledForExercises);
    }

    public boolean isEnabledPenalty() {
        if (this.enabledPenaltyForExercises == null || this.currentExercise == null || this.penaltyRule.isCustomPenalty()) {
            return true;
        }
        return this.currentExercise.getShortName().matches(this.enabledPenaltyForExercises);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public PenaltyRule getPenaltyRule() {
        if (this.isEnabledPenalty()) {
            return this.penaltyRule;
        }
        return new ThresholdPenaltyRule(1, 0.0);
    }

    public IRatingGroup getRatingGroup() {
        return this.ratingGroup;
    }

    public String getTooltip(String languageKey, List<IAnnotation> annotations) {
        String penaltyText = this.getPenaltyRule().getTooltip(annotations);
        return String.valueOf(this.getMessage(languageKey)) + "\n" + penaltyText;
    }

    public void setRatingGroup(RatingGroup ratingGroup) {
        if (this.ratingGroup == null) {
            this.ratingGroup = ratingGroup;
        }
    }

    public String toString() {
        return "MistakeType [identifier=" + this.identifier + ", name=" + this.buttonText + ", message=" + this.message + ", ratingGroup=" + this.ratingGroup + ", penaltyRule=" + this.penaltyRule + "]";
    }

    public boolean isCustomPenalty() {
        return this.penaltyRule.isCustomPenalty();
    }

    public int hashCode() {
        return Objects.hash(this.appliesTo, this.penaltyRule, this.identifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MistakeType other = (MistakeType)obj;
        return Objects.equals(this.appliesTo, other.appliesTo) && Objects.equals(this.penaltyRule, other.penaltyRule) && Objects.equals(this.identifier, other.identifier);
    }
}

