/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.api.model.IRatingGroup;
import edu.kit.kastel.eclipse.common.api.util.Pair;
import edu.kit.kastel.eclipse.common.core.model.MistakeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RatingGroup
implements IRatingGroup {
    @JsonProperty(value="shortName")
    private String identifier;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="additionalDisplayNames")
    private Map<String, String> additionalDisplayNames;
    @JsonProperty
    private Double positiveLimit;
    @JsonProperty
    private Double negativeLimit;
    private transient List<MistakeType> mistakeTypes = new ArrayList<MistakeType>();

    public void addMistakeType(MistakeType mistakeType) {
        this.mistakeTypes.add(mistakeType);
    }

    public String getDisplayName(String languageKey) {
        if (languageKey == null || this.additionalDisplayNames == null || !this.additionalDisplayNames.containsKey(languageKey)) {
            return this.displayName;
        }
        return this.additionalDisplayNames.get(languageKey);
    }

    public List<IMistakeType> getMistakeTypes() {
        return this.mistakeTypes.stream().map(IMistakeType.class::cast).collect(Collectors.toList());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Pair<Double, Double> getRange() {
        return new Pair((Object)this.negativeLimit, (Object)this.positiveLimit);
    }

    public double setToRange(double points) {
        if (this.negativeLimit != null && points < this.negativeLimit) {
            return this.negativeLimit;
        }
        if (this.positiveLimit != null && points > this.positiveLimit) {
            return this.positiveLimit;
        }
        return points;
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RatingGroup other = (RatingGroup)obj;
        return Objects.equals(this.identifier, other.identifier);
    }
}

