/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.model.annotation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import java.util.Optional;

public class Annotation
implements IAnnotation {
    private final String uuid;
    private IMistakeType mistakeType;
    private String mistakeTypeId;
    private final int startLine;
    private final int endLine;
    private final String fullyClassifiedClassName;
    private String customMessage;
    private Double customPenalty;

    public Annotation(String uuid, IMistakeType mistakeType, int startLine, int endLine, String fullyClassifiedClassName, String customMessage, Double customPenalty) {
        this.uuid = uuid;
        this.mistakeType = mistakeType;
        this.startLine = startLine;
        this.endLine = endLine;
        this.fullyClassifiedClassName = fullyClassifiedClassName;
        this.customMessage = customMessage;
        this.customPenalty = customPenalty;
    }

    @JsonCreator
    public Annotation(@JsonProperty(value="uuid") String uuid, @JsonProperty(value="startLine") int startLine, @JsonProperty(value="endLine") int endLine, @JsonProperty(value="classFilePath") String classFilePath, @JsonProperty(value="customMessageForJSON") String customMessage, @JsonProperty(value="customPenaltyForJSON") Double customPenalty, @JsonProperty(value="mistakeTypeId") String mistakeTypeId) {
        this.uuid = uuid == null ? IAnnotation.createID() : uuid;
        this.startLine = startLine;
        this.endLine = endLine;
        this.fullyClassifiedClassName = classFilePath;
        this.mistakeTypeId = mistakeTypeId;
        this.customMessage = customMessage;
        this.customPenalty = customPenalty;
    }

    public String getClassFilePath() {
        return this.fullyClassifiedClassName;
    }

    @JsonIgnore
    public Optional<String> getCustomMessage() {
        return this.customMessage == null ? Optional.empty() : Optional.of(this.customMessage);
    }

    public String getCustomMessageForJSON() {
        return this.customMessage;
    }

    @JsonIgnore
    public Optional<Double> getCustomPenalty() {
        return this.customPenalty == null ? Optional.empty() : Optional.of(this.customPenalty);
    }

    public Double getCustomPenaltyForJSON() {
        return this.customPenalty;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public String getUUID() {
        return this.uuid;
    }

    @JsonIgnore
    public IMistakeType getMistakeType() {
        return this.mistakeType;
    }

    public String getMistakeTypeId() {
        return this.mistakeType != null ? this.mistakeType.getIdentifier() : this.mistakeTypeId;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setMistakeType(IMistakeType mistakeType) {
        if (this.mistakeType != null) {
            return;
        }
        this.mistakeType = mistakeType;
    }

    public String toString() {
        return "Annotation [id=" + this.uuid + ", mistakeType=" + this.mistakeType + ", startLine=" + this.startLine + ", endLine=" + this.endLine + ", fullyClassifiedClassName=" + this.fullyClassifiedClassName + ", customMessage=" + this.customMessage + ", customPenalty=" + this.customPenalty + "]";
    }
}

