/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.model.rule;

import com.fasterxml.jackson.databind.JsonNode;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.core.model.rule.PenaltyRule;
import java.util.List;

public class CustomPenaltyRule
extends PenaltyRule {
    private static final String DISPLAY_NAME = "Custom Penalty";
    public static final String SHORT_NAME = "customPenalty";

    public CustomPenaltyRule(JsonNode penaltyRuleNode) {
    }

    @Override
    public double calculate(List<IAnnotation> annotations) {
        if (annotations != null) {
            return annotations.stream().mapToDouble(annotation -> annotation.getCustomPenalty().orElse(0.0)).sum();
        }
        return 0.0;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getTooltip(List<IAnnotation> annotations) {
        return this.calculate(annotations) + " points [" + annotations.size() + " annotations made]";
    }

    @Override
    public boolean isCustomPenalty() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

