/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.model.rule;

import com.fasterxml.jackson.databind.JsonNode;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.core.model.rule.PenaltyRule;
import java.util.List;
import java.util.Objects;

public class StackingPenaltyRule
extends PenaltyRule {
    private static final String DISPLAY_NAME = "Stacking Penalty";
    public static final String SHORT_NAME = "stackingPenalty";
    private int penalty;
    private Integer maxUses = null;

    public StackingPenaltyRule(JsonNode penaltyRuleNode) {
        this.penalty = (int)(penaltyRuleNode.get("penalty").asDouble() * 10.0);
        if (penaltyRuleNode.hasNonNull("maxUses")) {
            this.maxUses = penaltyRuleNode.get("maxUses").asInt();
        }
    }

    @Override
    public double calculate(List<IAnnotation> annotations) {
        int multiplier = this.maxUses == null ? annotations.size() : Math.min(annotations.size(), this.maxUses);
        return (double)(multiplier * -this.penalty) / 10.0;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getTooltip(List<IAnnotation> annotations) {
        double penaltyValue = this.calculate(annotations);
        String tooltip = String.valueOf(penaltyValue) + " points [" + annotations.size() + " annotations made";
        tooltip = String.valueOf(tooltip) + (this.maxUses != null ? " - capped to " + this.maxUses + " annotations" : "");
        tooltip = String.valueOf(tooltip) + "]";
        return tooltip;
    }

    public String toString() {
        String string = "StackingPenaltyRule [penalty=\" + this.penalty / 10.0 + \" per annotation";
        string = String.valueOf(string) + (this.maxUses != null ? " capped to " + this.maxUses + " annotations" : "");
        string = String.valueOf(string) + "]";
        return string;
    }

    @Override
    public boolean isCustomPenalty() {
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.maxUses, this.penalty);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StackingPenaltyRule other = (StackingPenaltyRule)obj;
        return Objects.equals(this.maxUses, other.maxUses) && this.penalty == other.penalty;
    }
}

