/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.grading.view.assessment;

import edu.kit.kastel.eclipse.common.api.artemis.mapping.Feedback;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.FeedbackType;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.controller.IGradingSystemwideController;
import edu.kit.kastel.eclipse.common.api.util.Pair;
import edu.kit.kastel.eclipse.common.view.ui.AbstractResultTab;
import java.util.List;
import org.eclipse.swt.widgets.TabFolder;

public class ResultTab
extends AbstractResultTab {
    private IGradingSystemwideController controller;

    public ResultTab(IGradingSystemwideController controller, TabFolder tabFolder) {
        super(tabFolder, false);
        this.controller = controller;
    }

    public void setController(IGradingSystemwideController controller) {
        this.controller = controller;
    }

    protected IExercise getCurrentExercise() {
        return this.controller.getCurrentAssessmentController().getExercise();
    }

    protected Pair<String, List<Feedback>> getCurrentResultAndFeedback() {
        ISubmission submission = this.controller.getCurrentAssessmentController().getSubmission();
        List feedbacks = this.controller.getArtemisController().getAllFeedbacksGottenFromLocking(submission);
        Object completionTime = null;
        return new Pair(completionTime, feedbacks.stream().filter(f -> f.getFeedbackType() == FeedbackType.AUTOMATIC).toList());
    }

    protected String getCurrentProjectNameForAnnotations() {
        return null;
    }

    protected String getCurrentSourceDirectoryRelative() {
        return null;
    }

    public void loadFeedbackForExcerise() {
        this.reloadFeedbackForExcerise();
    }

    public void reset() {
        this.resetView();
    }
}

