/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.view.ui;

import edu.kit.kastel.eclipse.common.api.artemis.mapping.Feedback;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.view.languages.LanguageSettings;
import edu.kit.kastel.eclipse.common.view.ui.AbstractResultTabComposite;
import edu.kit.kastel.eclipse.common.view.ui.TestDetailsDialog;
import edu.kit.kastel.eclipse.common.view.utilities.UIUtilities;
import java.util.Locale;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

abstract class AbstractResultTabCompositeController
extends AbstractResultTabComposite {
    private static final String CHECK_MARK_IN_UTF8 = "\u2713";
    private static final String X_MARK_IN_UTF8 = "\u2717";

    protected AbstractResultTabCompositeController(TabFolder tabFolder, boolean hasReloadFunctionality) {
        super((Composite)UIUtilities.createTabWithScrolledComposite(tabFolder, LanguageSettings.I18N().tabResults()), 0);
        if (!hasReloadFunctionality) {
            this.btnReload.setVisible(false);
        }
        this.btnReload.addListener(13, e -> this.reloadFeedbackForExcerise());
        this.testTable.addListener(13, this::handleResultTableEvent);
        UIUtilities.initializeTabAfterFilling(this.getParent(), this);
    }

    protected abstract void reloadFeedbackForExcerise();

    protected void setSuccessAndScore(IExercise currentExercise, boolean successOfAutomaticTests, double points, double score, String completionTime) {
        Display display = this.getDisplay();
        String title = currentExercise == null ? LanguageSettings.I18N().unknownTask() : currentExercise.getTitle();
        this.lblStateOfTests.setForeground(successOfAutomaticTests ? display.getSystemColor(5) : display.getSystemColor(3));
        this.lblStateOfTests.setText(String.valueOf(LanguageSettings.I18N().tests()) + " " + (successOfAutomaticTests ? LanguageSettings.I18N().successful() : LanguageSettings.I18N().unsuccessful()));
        this.lblTaskname.setText(title);
        this.lblTaskdetails.setText(completionTime == null ? "" : completionTime);
        this.lblScore.setText(String.format(Locale.ENGLISH, String.valueOf(LanguageSettings.I18N().score()) + ": %.2f%%", score));
        this.lblPoints.setText(String.format(Locale.ENGLISH, String.valueOf(LanguageSettings.I18N().points()) + ": %.2f", points));
    }

    protected void createTableItemsForFeedback(Table table, String name, Feedback feedback) {
        String roundedCredits = feedback.getCredits() == null ? "0.00" : String.format(Locale.ENGLISH, "%.2f", feedback.getCredits());
        String success = this.calculateSuccessMessage(feedback);
        int colorIndicator = this.calculateSuccessColorIndicator(feedback);
        TableItem item = new TableItem(table, 0);
        item.setData((Object)feedback);
        item.setText(0, name);
        item.setText(1, roundedCredits);
        item.setText(2, success);
        item.setForeground(2, Display.getDefault().getSystemColor(colorIndicator));
        item.setText(3, feedback.getDetailText() != null ? CHECK_MARK_IN_UTF8 : X_MARK_IN_UTF8);
    }

    private String calculateSuccessMessage(Feedback feedback) {
        if (feedback.getPositive() == null) {
            return "";
        }
        return Boolean.TRUE.equals(feedback.getPositive()) ? LanguageSettings.I18N().successful() : LanguageSettings.I18N().unsuccessful();
    }

    private int calculateSuccessColorIndicator(Feedback feedback) {
        if (feedback.getPositive() == null) {
            return 2;
        }
        return Boolean.TRUE.equals(feedback.getPositive()) ? 5 : 3;
    }

    protected final void loadingStarted() {
        this.loadingIndicator.setVisible(true);
    }

    protected final void loadingFinished() {
        this.loadingIndicator.setVisible(false);
    }

    private void handleResultTableEvent(Event e) {
        TableItem item = (TableItem)e.item;
        Feedback selectedFeedback = (Feedback)item.getData();
        if (selectedFeedback == null) {
            return;
        }
        if (selectedFeedback.getDetailText() != null) {
            String text = item.getText(0);
            new TestDetailsDialog(text, selectedFeedback.getDetailText()).open();
        }
    }

    protected final void resetView() {
        this.testTable.removeAll();
        this.loadingIndicator.setVisible(false);
        this.lblPoints.setText(POINTS);
        this.lblScore.setText(SCORE);
        this.lblStateOfTests.setText("StateOfTests");
        this.lblStateOfTests.setForeground(Display.getCurrent().getSystemColor(2));
        this.lblTaskdetails.setText("TaskDetails");
        this.lblTaskname.setText("TaskName");
    }
}

