/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.view.utilities;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.controller.IAssessmentController;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.view.languages.LanguageSettings;
import java.io.InputStream;
import java.util.Optional;
import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public final class AssessmentUtilities {
    public static final String MARKER_CLASS_NAME = "edu.kit.kastel.eclipse.common.view.assessment.marker";
    public static final String MARKER_ATTRIBUTE_ANNOTATION_ID = "annotationID";
    public static final String MARKER_ATTRIBUTE_ERROR = "errorType";
    public static final String MARKER_ATTRIBUTE_ERROR_DESCRIPTION = "errorTypeDescription";
    public static final String MARKER_ATTRIBUTE_CLASS_NAME = "className";
    public static final String MARKER_ATTRIBUTE_RATING_GROUP = "ratingGroup";
    public static final String MARKER_ATTRIBUTE_CUSTOM_PENALTY = "customPenalty";
    public static final String MARKER_ATTRIBUTE_CUSTOM_MESSAGE = "customMessage";
    public static final String MARKER_ATTRIBUTE_START = "start";
    public static final String MARKER_ATTRIBUTE_END = "end";
    private static final String PROJECT_EXPLORER_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    public static final String MARKER_VIEW_ID = "edu.kit.kastel.eclipse.common.view.annotationMarkerGenerator";
    public static final int BACKLOG_COMBO_WIDTH = 300;
    private static final ILog LOG = Platform.getLog(AssessmentUtilities.class);

    private AssessmentUtilities() {
        throw new IllegalAccessError();
    }

    public static String createMarkerTooltip(int startLine, int endline, String errorTypeName, String ratingGroupName, String message, String classPath) {
        return String.format("[%s,%s], %s, %s, %s, %s", startLine + 1, endline + 1, classPath == null ? AssessmentUtilities.getClassNameForAnnotation() : classPath, ratingGroupName, errorTypeName, message);
    }

    public static String createMarkerTooltipForCustomButton(int startLine, int endline, String customMessage, Double customPenalty) {
        return String.format("[%s,%s], %s, %s", startLine + 1, endline + 1, customMessage, customPenalty);
    }

    public static IFile getFile(String path, String projectName, String srcDirectory) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(String.valueOf(srcDirectory) + path);
    }

    public static IEditorPart getActiveEditor() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    public static String getClassNameForAnnotation() {
        return AssessmentUtilities.getActiveEditor().getEditorInput().getName();
    }

    public static IFile getCurrentlyOpenFile() {
        return (IFile)AssessmentUtilities.getActiveEditor().getEditorInput().getAdapter(IFile.class);
    }

    /*
     * WARNING - void declaration
     */
    public static String getPathForAnnotation() {
        void fileEditor;
        FileEditorInput fileEditorInput;
        IPath path;
        IEditorInput input;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow wb = workbench == null ? null : workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = wb == null ? null : window.getActivePage();
        IEditorPart editor = activePage == null ? null : activePage.getActiveEditor();
        IEditorInput iEditorInput = input = editor == null ? null : editor.getEditorInput();
        IPath iPath = path = iEditorInput instanceof FileEditorInput && (fileEditorInput = (FileEditorInput)iEditorInput) == (FileEditorInput)iEditorInput ? fileEditor.getPath() : null;
        if (path != null) {
            int srcIndex = 0;
            int i = 0;
            while (i < path.segments().length) {
                if ("src".equals(path.segments()[i])) {
                    srcIndex = i;
                    break;
                }
                ++i;
            }
            StringBuilder result = new StringBuilder().append("src");
            int j = srcIndex + 1;
            while (j < path.segments().length) {
                result.append("/");
                result.append(path.segments()[j]);
                ++j;
            }
            return result.toString();
        }
        return "";
    }

    public static ITextSelection getTextSelection() {
        IEditorPart part = AssessmentUtilities.getActiveEditor();
        if (part instanceof ITextEditor var1_2) {
            ISelection selection = editor.getSelectionProvider().getSelection();
            return (ITextSelection)selection;
        }
        return null;
    }

    public static Shell getWindowsShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window.getShell();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void createAssessmentAnnotation(IAssessmentController assessmentController, IMistakeType mistake, String customMessage, Double customPenalty) {
        ITextSelection textSelection = AssessmentUtilities.getTextSelection();
        if (textSelection == null) {
            assessmentController.getViewInteractionHandler().error("Text selection needed to add a new annotation", null);
            return;
        }
        int startLine = textSelection.getStartLine();
        int endLine = textSelection.getEndLine();
        IFile file = AssessmentUtilities.getCurrentlyOpenFile();
        String projectName = file.getProject().getName();
        String className = file.getFullPath().makeRelative().toString().split("src", 2)[1];
        try {
            String id = IAnnotation.createID();
            IMarker marker = AssessmentUtilities.getCurrentlyOpenFile().createMarker(MARKER_CLASS_NAME);
            marker.setAttribute(MARKER_ATTRIBUTE_ANNOTATION_ID, (Object)id);
            AssessmentUtilities.setCharPositionsInMarkerByLine(marker, projectName, "assignment/src", className, startLine, endLine);
            marker.setAttribute(MARKER_ATTRIBUTE_ERROR_DESCRIPTION, (Object)(mistake.isCustomPenalty() ? "" : mistake.getMessage(LanguageSettings.I18N().key())));
            marker.setAttribute(MARKER_ATTRIBUTE_ERROR, (Object)mistake.getButtonText(LanguageSettings.I18N().key()));
            marker.setAttribute(MARKER_ATTRIBUTE_START, startLine);
            marker.setAttribute(MARKER_ATTRIBUTE_END, endLine);
            marker.setAttribute(MARKER_ATTRIBUTE_CLASS_NAME, (Object)AssessmentUtilities.getClassNameForAnnotation());
            marker.setAttribute(MARKER_ATTRIBUTE_RATING_GROUP, (Object)mistake.getRatingGroup().getDisplayName(LanguageSettings.I18N().key()));
            if (customMessage != null) {
                marker.setAttribute(MARKER_ATTRIBUTE_CUSTOM_MESSAGE, (Object)customMessage);
            }
            if (customPenalty != null) {
                marker.setAttribute(MARKER_ATTRIBUTE_CUSTOM_PENALTY, (Object)customPenalty.toString());
            }
            if (!mistake.isCustomPenalty()) {
                marker.setAttribute("message", (Object)AssessmentUtilities.createMarkerTooltip(startLine, endLine, mistake.getButtonText(LanguageSettings.I18N().key()), mistake.getRatingGroup().getDisplayName(LanguageSettings.I18N().key()), AssessmentUtilities.formatCustomPenaltyMessage(mistake, customMessage), null));
            } else {
                marker.setAttribute("message", (Object)AssessmentUtilities.createMarkerTooltipForCustomButton(startLine, endLine, customMessage, customPenalty));
            }
            assessmentController.addAnnotation(id, mistake, startLine, endLine, AssessmentUtilities.getPathForAnnotation(), customMessage, customPenalty);
        }
        catch (Exception e) {
            assessmentController.getViewInteractionHandler().error("Unable to create marker for annotation: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void createMarkerByAnnotation(IAnnotation annotation, String currentProjectName, String srcDirectory) throws ArtemisClientException {
        int startLine = annotation.getStartLine();
        int endLine = annotation.getEndLine();
        IMistakeType mistake = annotation.getMistakeType();
        String customMessage = annotation.getCustomMessage().orElse(null);
        String customPenalty = annotation.getCustomPenalty().map(String::valueOf).orElse(null);
        try {
            IFile file = AssessmentUtilities.getFile(annotation.getClassFilePath(), currentProjectName, srcDirectory);
            IMarker marker = file.createMarker(MARKER_CLASS_NAME);
            marker.setAttribute(MARKER_ATTRIBUTE_ANNOTATION_ID, (Object)annotation.getUUID());
            AssessmentUtilities.setCharPositionsInMarkerByLine(marker, currentProjectName, srcDirectory, annotation.getClassFilePath(), startLine, endLine);
            marker.setAttribute(MARKER_ATTRIBUTE_START, startLine);
            marker.setAttribute(MARKER_ATTRIBUTE_END, endLine);
            marker.setAttribute(MARKER_ATTRIBUTE_CLASS_NAME, (Object)annotation.getClassFilePath());
            if (customMessage != null) {
                marker.setAttribute(MARKER_ATTRIBUTE_CUSTOM_MESSAGE, (Object)customMessage);
            }
            if (customPenalty != null) {
                marker.setAttribute(MARKER_ATTRIBUTE_CUSTOM_PENALTY, (Object)customPenalty);
            }
            if (mistake != null) {
                marker.setAttribute(MARKER_ATTRIBUTE_ERROR_DESCRIPTION, (Object)mistake.getMessage(LanguageSettings.I18N().key()));
                marker.setAttribute(MARKER_ATTRIBUTE_ERROR, (Object)mistake.getButtonText(LanguageSettings.I18N().key()));
                marker.setAttribute(MARKER_ATTRIBUTE_RATING_GROUP, (Object)mistake.getRatingGroup().getDisplayName(LanguageSettings.I18N().key()));
                if (!mistake.isCustomPenalty()) {
                    marker.setAttribute("message", (Object)AssessmentUtilities.createMarkerTooltip(startLine, endLine, mistake.getButtonText(LanguageSettings.I18N().key()), mistake.getRatingGroup().getDisplayName(LanguageSettings.I18N().key()), AssessmentUtilities.formatCustomPenaltyMessage(mistake, customMessage), annotation.getClassFilePath()));
                } else {
                    marker.setAttribute("message", (Object)AssessmentUtilities.createMarkerTooltipForCustomButton(startLine, endLine, customMessage, Double.parseDouble(customPenalty)));
                }
            } else if (customMessage != null) {
                marker.setAttribute("message", (Object)customMessage.replace("<br />", "\n"));
            }
        }
        catch (Exception e) {
            throw new ArtemisClientException(e.getMessage(), (Throwable)e);
        }
    }

    public static void setCharPositionsInMarkerByLine(IMarker marker, String currentProjectName, String srcDirectory, String classFileInPath, int startLine, int endLine) throws ArtemisClientException {
        try {
            InputStream contentStream = ResourcesPlugin.getWorkspace().getRoot().getProject(currentProjectName).getFile(String.valueOf(srcDirectory) + classFileInPath).getContents();
            Scanner s = new Scanner(contentStream).useDelimiter("\\A");
            String content = s.hasNext() ? s.next() : "";
            s.close();
            Document doc = new Document(content);
            int charOffsetStart = doc.getLineOffset(startLine);
            int charOffsetEnd = startLine == endLine ? charOffsetStart + doc.getLineLength(startLine) : doc.getLineOffset(endLine) + doc.getLineLength(endLine);
            marker.setAttribute("charStart", charOffsetStart);
            marker.setAttribute("charEnd", charOffsetEnd);
        }
        catch (Exception e) {
            throw new ArtemisClientException(e.getMessage(), (Throwable)e);
        }
    }

    public static void updateMarkerMessage(IMarker marker, String newMessage, Double newPenalty) throws ArtemisClientException {
        try {
            marker.setAttribute(MARKER_ATTRIBUTE_CUSTOM_MESSAGE, (Object)newMessage);
            marker.setAttribute(MARKER_ATTRIBUTE_CUSTOM_PENALTY, (Object)(newPenalty == null ? null : String.valueOf(newPenalty)));
            Integer startLine = (Integer)marker.getAttribute(MARKER_ATTRIBUTE_START);
            Integer endLine = (Integer)marker.getAttribute(MARKER_ATTRIBUTE_END);
            marker.setAttribute("message", (Object)AssessmentUtilities.createMarkerTooltipForCustomButton(startLine, endLine, newMessage, newPenalty));
        }
        catch (Exception e) {
            throw new ArtemisClientException(e.getMessage(), (Throwable)e);
        }
    }

    public static IMarker findPresentAnnotation(IAnnotation annotation, String currentProjectName, String srcDirectory) {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = AssessmentUtilities.getFile(annotation.getClassFilePath(), currentProjectName, srcDirectory).findMarkers(null, false, 100);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (annotation.getUUID().equals(marker.getAttribute(MARKER_ATTRIBUTE_ANNOTATION_ID))) {
                    return marker;
                }
                ++n2;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static String formatCustomPenaltyMessage(IMistakeType mistake, String customMessage) {
        if (customMessage != null) {
            return String.valueOf(mistake.getMessage(LanguageSettings.I18N().key())) + "\n" + customMessage;
        }
        return mistake.getMessage(LanguageSettings.I18N().key());
    }

    public static void openJavaElement(IJavaElement element, IWorkbenchPage page) {
        IPath path = element.getPath();
        Display.getDefault().asyncExec(() -> {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(path));
            }
            catch (Exception e) {
                LOG.error("Failed to open the java code element", (Throwable)e);
            }
        });
    }

    public static Optional<ProjectExplorer> getProjectExplorer(IWorkbenchPage page) {
        return Optional.ofNullable((ProjectExplorer)page.findView(PROJECT_EXPLORER_ID));
    }
}

