/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.view.utilities;

import edu.kit.kastel.eclipse.common.view.activator.CommonActivator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.editors.text.EditorsUI;
import org.osgi.service.prefs.BackingStoreException;

public final class PreferenceTweaker {
    private static final ILog log = Platform.getLog(PreferenceTweaker.class);
    private static final String JDT_IGNORE = "ignore";
    private static final String JDT_INFO = "info";
    private static final String JDT_WARNING = "warning";
    private static final String JDT_ERROR = "error";
    private static final String JDT_ENABLED = "enabled";
    private static final String JDT_DISABLED = "disabled";

    private PreferenceTweaker() {
        throw new IllegalAccessError();
    }

    public static void tweakPreferences() {
        IPreferenceStore preferences = CommonActivator.getDefault().getPreferenceStore();
        if (!preferences.getBoolean("override_default_preferences")) {
            return;
        }
        log.info("Tweaking default eclipse preferences");
        PreferenceTweaker.tweakEditorPreferences();
        PreferenceTweaker.tweakJdtPreferences();
    }

    private static void tweakEditorPreferences() {
        IPreferenceStore editorPreferences = EditorsUI.getPreferenceStore();
        editorPreferences.setValue("lineNumberRuler", true);
    }

    private static void tweakJdtPreferences() {
        IEclipsePreferences jdtPreferenceNode = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core");
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", JDT_IGNORE);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", JDT_IGNORE);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", JDT_INFO);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.autoboxing", JDT_INFO);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", JDT_INFO);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", JDT_INFO);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.deadCode", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.comparingIdentical", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.unlikelyEqualsArgumentType", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod", JDT_INFO);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", JDT_INFO);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", JDT_INFO);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding", JDT_DISABLED);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", JDT_WARNING);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", JDT_DISABLED);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", JDT_DISABLED);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", JDT_ERROR);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", JDT_INFO);
        jdtPreferenceNode.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", JDT_DISABLED);
        try {
            jdtPreferenceNode.sync();
            jdtPreferenceNode.flush();
        }
        catch (BackingStoreException e) {
            log.warn("Could not save modified eclipse preferences.", (Throwable)e);
        }
    }
}

