/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.client.mappings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ICourse;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExam;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.client.mappings.IMappingLoader;
import java.util.Date;
import java.util.Optional;

public class ArtemisExercise
implements IExercise {
    private static final long serialVersionUID = 5892461865571113106L;
    @JsonProperty(value="id")
    private int exerciseId;
    @JsonProperty
    private String title;
    @JsonProperty
    private String shortName;
    @JsonProperty
    private String testRepositoryUrl;
    @JsonProperty
    private Boolean secondCorrectionEnabled;
    @JsonProperty
    private String type;
    @JsonProperty
    private String assessmentType;
    @JsonProperty
    private double maxPoints;
    @JsonProperty
    private Date dueDate = null;
    @JsonProperty
    private Date startDate = null;
    private transient IMappingLoader client;
    private transient ICourse course;
    private transient Optional<IExam> exam;

    public int getExerciseId() {
        return this.exerciseId;
    }

    public boolean isSecondCorrectionEnabled() {
        return this.secondCorrectionEnabled != null && this.secondCorrectionEnabled != false;
    }

    public String getShortName() {
        if (this.shortName == null) {
            return this.title;
        }
        return this.shortName;
    }

    public String getTestRepositoryUrl() {
        return this.testRepositoryUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public double getMaxPoints() {
        return this.maxPoints;
    }

    public ICourse getCourse() {
        return this.course;
    }

    public void init(IMappingLoader client, ICourse course, Optional<IExam> exam) {
        this.client = client;
        this.course = course;
        this.exam = exam;
    }

    public void init(IMappingLoader client, ICourse course) {
        this.init(client, course, Optional.empty());
    }

    public ISubmission getSubmission(int id) throws ArtemisClientException {
        return this.client.getSubmissionById(this, id);
    }

    public boolean hasSecondCorrectionRound() {
        return this.exam.map(IExam::hasSecondCorrectionRound).orElse(false);
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    @JsonIgnore
    public boolean isAutomaticAssessment() {
        return "AUTOMATIC".equals(this.assessmentType);
    }

    @JsonIgnore
    public boolean isProgramming() {
        return "programming".equals(this.type);
    }
}

