/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.client.mappings.exam;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ICourse;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExam;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExerciseGroup;
import edu.kit.kastel.eclipse.common.client.mappings.IMappingLoader;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class ArtemisExam
implements IExam,
Serializable {
    private static final long serialVersionUID = 97898730702942861L;
    @JsonProperty(value="id")
    private int examId;
    @JsonProperty
    private String title;
    @JsonProperty(value="numberOfCorrectionRoundsInExam")
    private int numberOfCorrectionRounds;
    @JsonProperty
    private Date startDate;
    @JsonProperty
    private Date endDate;
    @JsonIgnore
    private transient ICourse course;
    @JsonIgnore
    private transient List<IExerciseGroup> exerciseGroups;
    @JsonIgnore
    private transient IMappingLoader client;

    public int getExamId() {
        return this.examId;
    }

    public List<IExerciseGroup> getExerciseGroups() throws ArtemisClientException {
        if (this.exerciseGroups == null) {
            this.exerciseGroups = this.client.getExerciseGroupsForExam(this, this.course);
        }
        return this.exerciseGroups;
    }

    public String getTitle() {
        return this.title;
    }

    public void init(IMappingLoader client, ICourse course) {
        this.course = course;
        this.client = client;
    }

    public boolean hasSecondCorrectionRound() {
        return this.numberOfCorrectionRounds >= 2;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getNumberOfCorrectionRounds() {
        return this.numberOfCorrectionRounds;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public ICourse getCourse() {
        return this.course;
    }
}

