/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.client.rest;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ICourse;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExam;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExerciseGroup;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.client.ICourseArtemisClient;
import edu.kit.kastel.eclipse.common.api.client.ISubmissionsArtemisClient;
import edu.kit.kastel.eclipse.common.client.mappings.ArtemisCourse;
import edu.kit.kastel.eclipse.common.client.mappings.ArtemisExercise;
import edu.kit.kastel.eclipse.common.client.mappings.ArtemisExerciseWrapper;
import edu.kit.kastel.eclipse.common.client.mappings.IMappingLoader;
import edu.kit.kastel.eclipse.common.client.mappings.exam.ArtemisExam;
import edu.kit.kastel.eclipse.common.client.mappings.exam.ArtemisExerciseGroup;
import edu.kit.kastel.eclipse.common.client.mappings.exam.ArtemisExerciseGroupWrapper;
import edu.kit.kastel.eclipse.common.client.rest.AbstractArtemisClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class MappingLoaderArtemisClient
extends AbstractArtemisClient
implements ICourseArtemisClient,
IMappingLoader {
    private ISubmissionsArtemisClient submissionClient;
    private final OkHttpClient client;

    public MappingLoaderArtemisClient(ISubmissionsArtemisClient submissionClient, String hostname, String token) {
        super(hostname);
        this.client = this.createClient(token);
        this.submissionClient = submissionClient;
    }

    public List<ICourse> getCoursesForAssessment() throws ArtemisClientException {
        ArtemisCourse[] coursesArray;
        Request request = new Request.Builder().url(this.path("courses")).get().build();
        ArtemisCourse[] artemisCourseArray = coursesArray = this.call(this.client, request, ArtemisCourse[].class);
        int n = coursesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArtemisCourse course = artemisCourseArray[n2];
            course.init(this);
            ++n2;
        }
        return Arrays.asList(coursesArray);
    }

    @Override
    public List<IExerciseGroup> getExerciseGroupsForExam(IExam artemisExam, ICourse course) throws ArtemisClientException {
        Request request = new Request.Builder().url(this.path("courses", course.getCourseId(), "exams", artemisExam.getExamId(), "exam-for-assessment-dashboard")).get().build();
        List<ArtemisExerciseGroup> exerciseGroups = this.call(this.client, request, ArtemisExerciseGroupWrapper.class).getExerciseGroups();
        for (ArtemisExerciseGroup exerciseGroup : exerciseGroups) {
            exerciseGroup.init(this, course, artemisExam);
        }
        return new ArrayList<IExerciseGroup>(exerciseGroups);
    }

    @Override
    public List<IExam> getExamsForCourse(ICourse artemisCourse) throws ArtemisClientException {
        ArtemisExam[] examsArray;
        Request request = new Request.Builder().url(this.path("courses", artemisCourse.getCourseId(), "exams")).get().build();
        ArtemisExam[] artemisExamArray = examsArray = this.call(this.client, request, ArtemisExam[].class);
        int n = examsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArtemisExam exam = artemisExamArray[n2];
            exam.init(this, artemisCourse);
            ++n2;
        }
        return Arrays.asList(examsArray);
    }

    @Override
    public List<IExercise> getGradingExercisesForCourse(ICourse artemisCourse) throws ArtemisClientException {
        Request request = new Request.Builder().url(this.path("courses", artemisCourse.getCourseId(), "with-exercises")).get().build();
        List<ArtemisExercise> exercises = this.call(this.client, request, ArtemisExerciseWrapper.class).getExercises();
        for (ArtemisExercise exercise : exercises) {
            exercise.init(this, artemisCourse, Optional.empty());
        }
        return exercises.stream().filter(IExercise::isProgramming).collect(Collectors.toList());
    }

    @Override
    public ISubmission getSubmissionById(IExercise artemisExercise, int submissionId) throws ArtemisClientException {
        return this.submissionClient.getSubmissionById(artemisExercise, submissionId);
    }
}

