/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.util.List;
import java.util.function.Predicate;
import org.eclipse.m2e.core.internal.lifecyclemapping.MappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class MojoExecutionFilter
implements Predicate<PluginExecutionMetadata> {
    private final List<LifecycleMappingFilter> filters;

    public MojoExecutionFilter(List<MappingMetadataSource> metadataSources, MojoExecutionKey executionKey) {
        this.filters = metadataSources.stream().flatMap(s -> s.getFilters().stream()).filter(filter -> filter.getPluginExecutions().stream().anyMatch(f -> f.match(executionKey))).toList();
    }

    @Override
    public boolean test(PluginExecutionMetadata metadata) {
        return MojoExecutionFilter.anyMatch(metadata.getSource(), this.filters);
    }

    /*
     * WARNING - void declaration
     */
    static boolean anyMatch(LifecycleMappingMetadataSource source, List<LifecycleMappingFilter> filters) {
        void bundle;
        Bundle bundle2;
        Object object;
        return source != null && (object = source.getSource()) instanceof Bundle && (bundle2 = (Bundle)object) == (Bundle)object && MojoExecutionFilter.anyFilterMatches((Bundle)bundle, filters);
    }

    private static boolean anyFilterMatches(Bundle bundle, List<LifecycleMappingFilter> filters) {
        Version version = bundle.getVersion();
        return filters.stream().filter(f -> f.getSymbolicName().equals(bundle.getSymbolicName())).anyMatch(filter -> filter.matches(String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMicro()));
    }
}

