/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.internal.parser.html;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.ListAttributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractSaxHtmlParser {
    private static final Pattern HEADING_PATTERN = Pattern.compile("h([1-6])");
    private static Set<String> blockElements = Set.of("div", "dl", "form", "h1", "h2", "h3", "h4", "h5", "h6", "ol", "p", "pre", "table", "textarea", "td", "tr", "ul", "tbody", "thead", "tfoot", "li", "dd", "dt", "blockquote");
    private static Set<String> whitespaceCollapsingElements = Set.of("br", "hr");
    private static Set<String> noCharacterContentElements = Set.of("ul", "ol", "table", "tbody", "thead", "tr");
    private static final Map<String, DocumentBuilder.SpanType> elementNameToSpanType = Map.ofEntries(Map.entry("a", DocumentBuilder.SpanType.LINK), Map.entry("b", DocumentBuilder.SpanType.BOLD), Map.entry("cite", DocumentBuilder.SpanType.CITATION), Map.entry("i", DocumentBuilder.SpanType.ITALIC), Map.entry("em", DocumentBuilder.SpanType.EMPHASIS), Map.entry("strong", DocumentBuilder.SpanType.STRONG), Map.entry("del", DocumentBuilder.SpanType.DELETED), Map.entry("strike", DocumentBuilder.SpanType.DELETED), Map.entry("s", DocumentBuilder.SpanType.DELETED), Map.entry("ins", DocumentBuilder.SpanType.INSERTED), Map.entry("q", DocumentBuilder.SpanType.QUOTE), Map.entry("u", DocumentBuilder.SpanType.UNDERLINED), Map.entry("sup", DocumentBuilder.SpanType.SUPERSCRIPT), Map.entry("sub", DocumentBuilder.SpanType.SUBSCRIPT), Map.entry("span", DocumentBuilder.SpanType.SPAN), Map.entry("font", DocumentBuilder.SpanType.SPAN), Map.entry("code", DocumentBuilder.SpanType.CODE), Map.entry("tt", DocumentBuilder.SpanType.MONOSPACE), Map.entry("mark", DocumentBuilder.SpanType.MARK));
    private static final Map<String, DocumentBuilder.BlockType> elementNameToBlockType = Map.ofEntries(Map.entry("ul", DocumentBuilder.BlockType.BULLETED_LIST), Map.entry("code", DocumentBuilder.BlockType.CODE), Map.entry("div", DocumentBuilder.BlockType.DIV), Map.entry("footnote", DocumentBuilder.BlockType.FOOTNOTE), Map.entry("li", DocumentBuilder.BlockType.LIST_ITEM), Map.entry("ol", DocumentBuilder.BlockType.NUMERIC_LIST), Map.entry("dl", DocumentBuilder.BlockType.DEFINITION_LIST), Map.entry("dt", DocumentBuilder.BlockType.DEFINITION_TERM), Map.entry("dd", DocumentBuilder.BlockType.DEFINITION_ITEM), Map.entry("p", DocumentBuilder.BlockType.PARAGRAPH), Map.entry("pre", DocumentBuilder.BlockType.PREFORMATTED), Map.entry("blockquote", DocumentBuilder.BlockType.QUOTE), Map.entry("table", DocumentBuilder.BlockType.TABLE), Map.entry("th", DocumentBuilder.BlockType.TABLE_CELL_HEADER), Map.entry("td", DocumentBuilder.BlockType.TABLE_CELL_NORMAL), Map.entry("tr", DocumentBuilder.BlockType.TABLE_ROW));

    private Attributes computeAttributes(DocumentBuilder.SpanType spanType, org.xml.sax.Attributes atts) {
        String href;
        Attributes attributes = spanType == DocumentBuilder.SpanType.LINK ? new LinkAttributes() : new Attributes();
        this.populateCommonAttributes(attributes, atts);
        if (spanType == DocumentBuilder.SpanType.LINK && (href = this.getValue("href", atts)) != null) {
            ((LinkAttributes)attributes).setHref(href);
        }
        return attributes;
    }

    private String getValue(String name, org.xml.sax.Attributes atts) {
        for (int x = 0; x < atts.getLength(); ++x) {
            String localName = atts.getLocalName(x);
            if (!localName.equals(name)) continue;
            return atts.getValue(x);
        }
        return null;
    }

    private Attributes computeAttributes(org.xml.sax.Attributes atts) {
        Attributes attributes = new Attributes();
        this.populateCommonAttributes(attributes, atts);
        return attributes;
    }

    private String getAttribute(org.xml.sax.Attributes atts, String name) {
        for (int x = 0; x < atts.getLength(); ++x) {
            String localName = atts.getLocalName(x);
            if (!name.equals(localName)) continue;
            return atts.getValue(x);
        }
        return null;
    }

    private void populateCommonAttributes(Attributes attributes, org.xml.sax.Attributes atts) {
        for (int x = 0; x < atts.getLength(); ++x) {
            String localName = atts.getLocalName(x);
            if (localName.equals("id") || localName.equals("name")) {
                attributes.setId(atts.getValue(x));
                continue;
            }
            if (localName.equals("style")) {
                attributes.setCssStyle(atts.getValue(x));
                continue;
            }
            if (localName.equals("class")) {
                attributes.setCssClass(atts.getValue(x));
                continue;
            }
            if (localName.equals("title")) {
                attributes.setTitle(atts.getValue(x));
                continue;
            }
            if (!localName.equals("color")) continue;
            attributes.appendCssStyle("color: " + atts.getValue(x) + ";");
        }
    }

    private static String trimRight(String text) {
        int len;
        for (len = text.length(); 0 < len && text.charAt(len - 1) <= ' '; --len) {
        }
        return len < text.length() ? text.substring(0, len) : text;
    }

    private static String trimLeft(String text) {
        int st;
        int len = text.length();
        for (st = 0; st < len && text.charAt(st) <= ' '; ++st) {
        }
        return st > 0 ? text.substring(st, len) : text;
    }

    protected abstract void parse(InputSource var1, DocumentBuilder var2, ContentHandler var3) throws IOException, SAXException;

    public void parse(InputSource input, DocumentBuilder builder, boolean asDocument) throws IOException, SAXException {
        this.parse(input, builder, this.createContentHandler(builder, asDocument));
    }

    protected ContentHandler createContentHandler(DocumentBuilder builder) {
        return this.createContentHandler(builder, true);
    }

    protected ContentHandler createContentHandler(DocumentBuilder builder, boolean asDocument) {
        return new DocumentBuilderAdapter(builder, asDocument);
    }

    private class DocumentBuilderAdapter
    implements ContentHandler {
        private final Stack<ElementHandler> handlers = new Stack();
        private ElementState elementState;
        private final DocumentBuilder builder;
        private boolean processingContent;
        private final StringBuilder elementText = new StringBuilder();
        private final boolean asDocument;

        public DocumentBuilderAdapter(DocumentBuilder builder, boolean asDocument) {
            this.builder = builder;
            this.asDocument = asDocument;
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes atts) throws SAXException {
            String lowerCaseName = localName.toLowerCase();
            if (this.processingContent) {
                this.emitText(this.elementState, lowerCaseName, false);
            }
            this.elementState = new ElementState(this.elementState, lowerCaseName);
            if (!this.processingContent && lowerCaseName.equals("body")) {
                this.processingContent = true;
            }
            if (this.elementState.parent != null) {
                ++this.elementState.parent.childCount;
            }
            ElementHandler handler = this.computeElementHandler(lowerCaseName);
            this.handlers.push(handler);
            handler.start(atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.emitText(this.elementState, null, true);
            String lowerCaseName = localName.toLowerCase();
            this.elementState = this.elementState.parent;
            if (this.processingContent && lowerCaseName.equals("body")) {
                this.processingContent = false;
            }
            if (!this.processingContent) {
                return;
            }
            ElementHandler handler = this.handlers.pop();
            handler.end();
        }

        private void emitText(ElementState elementState, String nextElementName, boolean elementClosing) {
            String text = this.elementText.toString();
            if (!elementState.canHaveCharacterContent) {
                text = text.trim();
            } else if (!elementState.preserveWhitespace) {
                if (elementClosing) {
                    if (elementState.childCount == 0) {
                        if (elementState.blockElement) {
                            text = text.trim();
                        }
                    } else if (elementState.blockElement) {
                        text = AbstractSaxHtmlParser.trimRight(text);
                    }
                } else {
                    String originalText = text;
                    if (elementState.blockElement && elementState.childCount == 0 && (text = AbstractSaxHtmlParser.trimLeft(text)).length() == 0 && originalText.length() > 0) {
                        text = originalText.substring(0, 1);
                    }
                    if (nextElementName != null && blockElements.contains(nextElementName)) {
                        text = AbstractSaxHtmlParser.trimRight(text);
                    }
                }
            }
            this.elementText.delete(0, this.elementText.length());
            if (text.length() > 0) {
                this.handlers.peek().characters(text);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.processingContent) {
                if (this.elementState.noWhitespaceTextContainer && (this.elementState.lastChild == null || this.elementState.lastChild.blockElement) || this.elementState.blockElement && !this.elementState.preserveWhitespace && this.elementState.textChildCount == 0 && this.elementState.childCount == 0 || this.elementState.lastChild != null && this.elementState.lastChild.collapsesAdjacentWhitespace) {
                    int skip;
                    for (skip = 0; skip < length && Character.isWhitespace(ch[start + skip]); ++skip) {
                    }
                    start += skip;
                    length -= skip;
                }
                this.elementState.lastChild = null;
                if (length != 0) {
                    ++this.elementState.textChildCount;
                    this.append(this.elementState, ch, start, length);
                }
            }
        }

        private void append(ElementState elementState, char[] ch, int start, int length) {
            if (!elementState.preserveWhitespace) {
                int previousWhitespaceIndex = Integer.MIN_VALUE;
                for (int x = 0; x < length; ++x) {
                    int index = start + x;
                    char c = ch[index];
                    if (Character.isWhitespace(c)) {
                        if (previousWhitespaceIndex == index - 1) {
                            previousWhitespaceIndex = index;
                            continue;
                        }
                        previousWhitespaceIndex = index;
                        this.elementText.append(c == '\t' ? c : (char)' ');
                        continue;
                    }
                    this.elementText.append(c);
                }
            } else {
                this.elementText.append(ch, start, length);
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
            if (this.asDocument) {
                this.builder.beginDocument();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.asDocument) {
                this.builder.endDocument();
            } else {
                this.builder.flush();
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.processingContent && this.elementState.preserveWhitespace) {
                this.characters(ch, start, length);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        private ElementHandler computeElementHandler(String elementName) {
            ElementHandler outerHandler;
            DocumentBuilder.BlockType blockType = elementNameToBlockType.get(elementName);
            if (blockType == null) {
                DocumentBuilder.SpanType spanType = elementNameToSpanType.get(elementName);
                if (spanType != null) {
                    if (elementName.equals("font")) {
                        return new FontElementHandler(spanType);
                    }
                    return new SpanElementHandler(spanType);
                }
                if (elementName.equals("img")) {
                    return new ImageElementHandler();
                }
                if (elementName.equals("br")) {
                    return new LineBreakHandler();
                }
                if (elementName.equals("hr")) {
                    return new HorizontalRuleHandler();
                }
                Matcher headingMatcher = HEADING_PATTERN.matcher(elementName);
                if (headingMatcher.matches()) {
                    return new HeadingElementHandler(Integer.parseInt(headingMatcher.group(1)));
                }
                return new ContentElementHandler();
            }
            if (blockType == DocumentBuilder.BlockType.CODE && !this.handlers.isEmpty() && !((outerHandler = this.handlers.peek()) instanceof PreformattedBlockElementHandler)) {
                return new SpanElementHandler(DocumentBuilder.SpanType.CODE);
            }
            if (blockType == DocumentBuilder.BlockType.PREFORMATTED) {
                return new PreformattedBlockElementHandler();
            }
            if (blockType == DocumentBuilder.BlockType.NUMERIC_LIST) {
                return new NumericListElementHandler();
            }
            return new BlockElementHandler(blockType);
        }

        private abstract class ElementHandler {
            private ElementHandler() {
            }

            abstract void start(org.xml.sax.Attributes var1);

            abstract void end();

            void characters(String s) {
                DocumentBuilderAdapter.this.builder.characters(s);
            }
        }

        private class FontElementHandler
        extends ElementHandler {
            private final DocumentBuilder.SpanType spanType;
            private boolean noop;

            private FontElementHandler(DocumentBuilder.SpanType spanType) {
                this.spanType = spanType;
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
                Attributes attributes = this.computeFontAttributes(atts);
                if (this.spanType == DocumentBuilder.SpanType.SPAN && attributes.getCssClass() == null && attributes.getCssStyle() == null && attributes.getId() == null) {
                    this.noop = true;
                } else {
                    DocumentBuilderAdapter.this.builder.beginSpan(this.spanType, attributes);
                }
            }

            @Override
            public void end() {
                if (!this.noop) {
                    DocumentBuilderAdapter.this.builder.endSpan();
                }
            }

            private Attributes computeFontAttributes(org.xml.sax.Attributes atts) {
                Attributes attributes = AbstractSaxHtmlParser.this.computeAttributes(this.spanType, atts);
                for (int x = 0; x < atts.getLength(); ++x) {
                    String localName = atts.getLocalName(x);
                    if (localName.equals("face")) {
                        attributes.appendCssStyle("font-family: " + atts.getValue(x) + ";");
                        continue;
                    }
                    if (!localName.equals("size")) continue;
                    attributes.appendCssStyle("font-size: " + atts.getValue(x) + ";");
                }
                return attributes;
            }
        }

        private class SpanElementHandler
        extends ElementHandler {
            private final DocumentBuilder.SpanType spanType;
            private boolean noop;

            private SpanElementHandler(DocumentBuilder.SpanType spanType) {
                this.spanType = spanType;
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
                Attributes attributes = AbstractSaxHtmlParser.this.computeAttributes(this.spanType, atts);
                if (this.spanType == DocumentBuilder.SpanType.SPAN && attributes.getCssClass() == null && attributes.getCssStyle() == null && attributes.getId() == null) {
                    this.noop = true;
                } else {
                    DocumentBuilderAdapter.this.builder.beginSpan(this.spanType, attributes);
                }
            }

            @Override
            public void end() {
                if (!this.noop) {
                    DocumentBuilderAdapter.this.builder.endSpan();
                }
            }
        }

        private class ImageElementHandler
        extends ElementHandler {
            private ImageElementHandler() {
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
                Attributes attributes = AbstractSaxHtmlParser.this.computeAttributes(DocumentBuilder.SpanType.SPAN, atts);
                DocumentBuilderAdapter.this.builder.image(attributes, AbstractSaxHtmlParser.this.getValue("src", atts));
            }

            @Override
            public void end() {
            }
        }

        private class LineBreakHandler
        extends ElementHandler {
            private LineBreakHandler() {
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
            }

            @Override
            public void end() {
                DocumentBuilderAdapter.this.builder.lineBreak();
            }
        }

        private class HorizontalRuleHandler
        extends ElementHandler {
            private HorizontalRuleHandler() {
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
            }

            @Override
            public void end() {
                DocumentBuilderAdapter.this.builder.horizontalRule();
            }
        }

        private class HeadingElementHandler
        extends ElementHandler {
            int level;

            private HeadingElementHandler(int level) {
                this.level = level;
            }

            @Override
            void start(org.xml.sax.Attributes atts) {
                DocumentBuilderAdapter.this.builder.beginHeading(this.level, AbstractSaxHtmlParser.this.computeAttributes(atts));
            }

            @Override
            void end() {
                DocumentBuilderAdapter.this.builder.endHeading();
            }
        }

        private class ContentElementHandler
        extends ElementHandler {
            private ContentElementHandler() {
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
            }

            @Override
            public void end() {
            }
        }

        private class PreformattedBlockElementHandler
        extends ElementHandler {
            private org.xml.sax.Attributes atts;

            private PreformattedBlockElementHandler() {
            }

            @Override
            void start(org.xml.sax.Attributes atts) {
                this.atts = new AttributesImpl(atts);
            }

            @Override
            void end() {
                if (this.atts == null) {
                    DocumentBuilderAdapter.this.builder.endBlock();
                }
            }

            @Override
            void characters(String s) {
                if (this.atts != null) {
                    DocumentBuilderAdapter.this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, AbstractSaxHtmlParser.this.computeAttributes(this.atts));
                    this.atts = null;
                }
                super.characters(s);
            }
        }

        private class NumericListElementHandler
        extends BlockElementHandler {
            NumericListElementHandler() {
                super(DocumentBuilder.BlockType.NUMERIC_LIST);
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
                String typeAttribute;
                ListAttributes listAttributes = new ListAttributes();
                AbstractSaxHtmlParser.this.populateCommonAttributes(listAttributes, atts);
                listAttributes.setStart(AbstractSaxHtmlParser.this.getAttribute(atts, "start"));
                if (!(listAttributes.getCssStyle() != null && listAttributes.getCssStyle().contains("list-style-type:") || (typeAttribute = AbstractSaxHtmlParser.this.getAttribute(atts, "type")) == null)) {
                    String listCssType = null;
                    switch (typeAttribute) {
                        case "1": {
                            listCssType = "decimal";
                            break;
                        }
                        case "a": {
                            listCssType = "lower-alpha";
                            break;
                        }
                        case "i": {
                            listCssType = "lower-roman";
                            break;
                        }
                        case "A": {
                            listCssType = "upper-alpha";
                            break;
                        }
                        case "I": {
                            listCssType = "upper-roman";
                        }
                    }
                    listAttributes.appendCssStyle("list-style-type: " + listCssType + ";");
                }
                DocumentBuilderAdapter.this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, listAttributes);
            }
        }

        private class BlockElementHandler
        extends ElementHandler {
            private final DocumentBuilder.BlockType blockType;

            BlockElementHandler(DocumentBuilder.BlockType blockType) {
                this.blockType = blockType;
            }

            @Override
            public void start(org.xml.sax.Attributes atts) {
                DocumentBuilderAdapter.this.builder.beginBlock(this.blockType, AbstractSaxHtmlParser.this.computeAttributes(atts));
            }

            @Override
            public void end() {
                DocumentBuilderAdapter.this.builder.endBlock();
            }

            @Override
            public void characters(String s) {
                DocumentBuilderAdapter.this.builder.characters(s);
            }
        }
    }

    private static final class ElementState {
        final String elementName;
        final ElementState parent;
        final boolean preserveWhitespace;
        final boolean blockElement;
        final boolean noWhitespaceTextContainer;
        final boolean collapsesAdjacentWhitespace;
        final boolean canHaveCharacterContent;
        int childCount = 0;
        int textChildCount = 0;
        ElementState lastChild;

        private ElementState(ElementState parent, String elementName) {
            this.parent = parent;
            this.elementName = elementName;
            this.blockElement = blockElements.contains(elementName);
            this.collapsesAdjacentWhitespace = this.blockElement || whitespaceCollapsingElements.contains(elementName);
            this.noWhitespaceTextContainer = "body".equals(elementName);
            this.preserveWhitespace = parent != null && parent.preserveWhitespace || "pre".equals(elementName);
            boolean bl = this.canHaveCharacterContent = !noCharacterContentElements.contains(elementName);
            if (parent != null) {
                parent.lastChild = this;
            }
        }
    }
}

