/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import net.sf.eclipsecs.core.jobs.AbstractCheckJob;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.ExtensionClassLoader;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.properties.filter.CheckFileOnOpenPartListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.framework.BundleContext;

public class CheckstyleUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "net.sf.eclipsecs.ui";
    public static final String QUICKFIX_PROVIDER_EXT_PT_ID = "net.sf.eclipsecs.ui.checkstyleQuickfixProvider";
    private static CheckstyleUIPlugin sPlugin;
    private static Boolean isEclipse3;
    private final CheckFileOnOpenPartListener mPartListener = new CheckFileOnOpenPartListener();
    private final IWindowListener mWindowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener2)CheckstyleUIPlugin.this.mPartListener);
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.getPartService().removePartListener((IPartListener2)CheckstyleUIPlugin.this.mPartListener);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }
    };
    private ClassLoader mQuickfixExtensionClassLoader;

    public CheckstyleUIPlugin() {
        sPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.mQuickfixExtensionClassLoader = new ExtensionClassLoader(context.getBundle(), QUICKFIX_PROVIDER_EXT_PT_ID);
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    if (window != null) {
                        IWorkbenchPage[] pages;
                        HashSet<IWorkbenchPartReference> parts = new HashSet<IWorkbenchPartReference>();
                        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                        int n3 = pages.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                            IEditorReference[] editorRefs = page.getEditorReferences();
                            Collections.addAll(parts, editorRefs);
                            ++n4;
                        }
                        CheckstyleUIPlugin.this.mPartListener.partsOpened(parts);
                        window.getPartService().removePartListener((IPartListener2)CheckstyleUIPlugin.this.mPartListener);
                        window.getPartService().addPartListener((IPartListener2)CheckstyleUIPlugin.this.mPartListener);
                    }
                    ++n2;
                }
                workbench.addWindowListener(CheckstyleUIPlugin.this.mWindowListener);
                CheckstyleUIPlugin.this.registerProgressIcon();
            }
        });
    }

    protected void registerProgressIcon() {
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        if (service == null) {
            return;
        }
        service.registerIconForFamily(CheckstyleUIPluginImages.CHECKSTYLE_ICON.getImageDescriptor(), AbstractCheckJob.CHECKSTYLE_JOB_FAMILY);
    }

    public void stop(BundleContext context) throws Exception {
        CheckstyleUIPluginImages.clearCachedImages();
        super.stop(context);
    }

    public static boolean isE3() {
        if (isEclipse3 == null) {
            try {
                Class.forName("org.eclipse.e4.ui.model.application.MApplicationElement");
                isEclipse3 = false;
            }
            catch (ClassNotFoundException ex) {
                isEclipse3 = true;
            }
        }
        return isEclipse3;
    }

    public static CheckstyleUIPlugin getDefault() {
        return sPlugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Locale getPlatformLocale() {
        String locale = Platform.getNL();
        String[] parts = locale.split("_");
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        String variant = parts.length > 2 ? parts[2] : "";
        return new Locale(language, country, variant);
    }

    public static void errorDialog(Shell shell, String message, Throwable throwable, boolean log) {
        Status status = new Status(4, PLUGIN_ID, 0, message != null ? message : "", throwable);
        String msg = NLS.bind((String)Messages.errorDialogMainMessage, (Object)message);
        ErrorDialog.openError((Shell)shell, (String)Messages.CheckstyleLog_titleInternalError, (String)msg, (IStatus)status);
        if (log) {
            CheckstyleLog.log((Throwable)throwable);
        }
    }

    public static void errorDialog(Shell shell, Throwable throwable, boolean log) {
        CheckstyleUIPlugin.errorDialog(shell, throwable.getLocalizedMessage(), throwable, log);
    }

    public static void warningDialog(Shell shell, String message, Throwable throwable) {
        Status status = new Status(2, PLUGIN_ID, 0, throwable.getLocalizedMessage(), throwable);
        ErrorDialog.openError((Shell)shell, (String)Messages.CheckstyleLog_titleWarning, (String)message, (IStatus)status);
    }

    public ClassLoader getQuickfixExtensionClassLoader() {
        return this.mQuickfixExtensionClassLoader;
    }
}

