/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.eclipsecs.core.jobs.RunCheckstyleOnFilesJob;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CheckSelectedFilesAction
implements IObjectActionDelegate {
    private IWorkbenchPart mPart;
    private IStructuredSelection mSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.mPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.mSelection = (IStructuredSelection)selection;
        }
    }

    public void run(IAction action) {
        ArrayList<IFile> filesToCheck = new ArrayList<IFile>();
        try {
            this.addFileResources(this.mSelection.toList(), filesToCheck);
            RunCheckstyleOnFilesJob job = new RunCheckstyleOnFilesJob(filesToCheck);
            job.setRule((ISchedulingRule)job);
            job.schedule();
        }
        catch (CoreException ex) {
            CheckstyleUIPlugin.errorDialog(this.mPart.getSite().getShell(), ex, true);
        }
    }

    private void addFileResources(List<IResource> resources, List<IFile> files) throws CoreException {
        for (IResource resource : resources) {
            if (!resource.isAccessible()) continue;
            if (resource instanceof IFile) {
                files.add((IFile)resource);
                continue;
            }
            if (!(resource instanceof IContainer)) continue;
            this.addFileResources(Arrays.asList(((IContainer)resource).members()), files);
        }
    }
}

