/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationWorkingCopy;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConfigureProjectFromBluePrintAction
implements IObjectActionDelegate {
    private IWorkbenchPart mPart;
    private Collection<IProject> mSelectedProjects;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.mPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            this.mSelectedProjects = sel.toList();
        }
    }

    public void run(IAction action) {
        Object[] result;
        IProject[] projects = CheckstyleUIPlugin.getWorkspace().getRoot().getProjects();
        ArrayList filteredProjects = new ArrayList();
        Collections.addAll(filteredProjects, projects);
        filteredProjects.removeAll(this.mSelectedProjects);
        ListDialog dialog = new ListDialog(this.mPart.getSite().getShell());
        dialog.setHelpAvailable(false);
        dialog.setInput(filteredProjects);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new WorkbenchLabelProvider());
        dialog.setMessage(Messages.ConfigureProjectFromBluePrintAction_msgSelectBlueprintProject);
        dialog.setTitle(Messages.ConfigureProjectFromBluePrintAction_titleSelectBlueprintProject);
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0) {
            BulkConfigureJob job = new BulkConfigureJob((IProject)result[0], this.mSelectedProjects);
            job.schedule();
        }
    }

    private static class BulkConfigureJob
    extends WorkspaceJob {
        private final IProject mBlueprint;
        private final Collection<IProject> mProjectsToConfigure;

        public BulkConfigureJob(IProject blueprint, Collection<IProject> projectsToConfigure) {
            super(Messages.ConfigureProjectFromBluePrintAction_msgConfiguringFromBluePrint);
            this.mBlueprint = blueprint;
            this.mProjectsToConfigure = projectsToConfigure;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            try {
                IProjectConfiguration bluePrintConfig = ProjectConfigurationFactory.getConfiguration((IProject)this.mBlueprint);
                List bluePrintLocalConfigs = bluePrintConfig.getLocalCheckConfigurations();
                for (IProject configurationTarget : this.mProjectsToConfigure) {
                    IProjectConfiguration config = ProjectConfigurationFactory.getConfiguration((IProject)configurationTarget);
                    ProjectConfigurationWorkingCopy workingCopy = new ProjectConfigurationWorkingCopy(config);
                    workingCopy.getFileSets().clear();
                    workingCopy.getFilters().clear();
                    ICheckConfigurationWorkingSet checkConfigsWorkingSet = workingCopy.getLocalCheckConfigWorkingSet();
                    for (ICheckConfiguration localConfig : workingCopy.getLocalCheckConfigurations()) {
                        if (!(localConfig instanceof CheckConfigurationWorkingCopy)) continue;
                        checkConfigsWorkingSet.removeCheckConfiguration((CheckConfigurationWorkingCopy)localConfig);
                    }
                    for (ICheckConfiguration localConfig : bluePrintLocalConfigs) {
                        CheckConfigurationWorkingCopy newCopy = checkConfigsWorkingSet.newWorkingCopy(localConfig);
                        checkConfigsWorkingSet.addCheckConfiguration(newCopy);
                    }
                    workingCopy.setUseSimpleConfig(bluePrintConfig.isUseSimpleConfig());
                    workingCopy.getFileSets().addAll(bluePrintConfig.getFileSets());
                    workingCopy.getFilters().addAll(bluePrintConfig.getFilters());
                    workingCopy.store();
                }
            }
            catch (CheckstylePluginException ex) {
                return new Status(4, "net.sf.eclipsecs.ui", 0, ex.getMessage(), (Throwable)ex);
            }
            return Status.OK_STATUS;
        }
    }
}

