/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.configtypes;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ConfigurationWriter;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.ExternalFileConfigurationType;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationPropertiesDialog;
import net.sf.eclipsecs.ui.config.configtypes.ICheckConfigurationEditor;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExternalFileConfigurationEditor
implements ICheckConfigurationEditor {
    private CheckConfigurationWorkingCopy mWorkingCopy;
    private Text mConfigName;
    private Text mLocation;
    private Button mBtnBrowse;
    private Text mDescription;
    private Button mChkProtectConfig;

    @Override
    public void initialize(CheckConfigurationWorkingCopy checkConfiguration, CheckConfigurationPropertiesDialog dialog) {
        this.mWorkingCopy = checkConfiguration;
    }

    @Override
    public Control createEditorControl(Composite parent, final Shell shell) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        contents.setLayout((Layout)layout);
        Label lblConfigName = new Label(contents, 0);
        lblConfigName.setText(Messages.CheckConfigurationPropertiesDialog_lblName);
        GridData gridData = new GridData();
        lblConfigName.setLayoutData((Object)gridData);
        this.mConfigName = new Text(contents, 18436);
        gridData = new GridData(768);
        this.mConfigName.setLayoutData((Object)gridData);
        this.mConfigName.setFocus();
        Label lblConfigLocation = new Label(contents, 0);
        lblConfigLocation.setText(Messages.CheckConfigurationPropertiesDialog_lblLocation);
        gridData = new GridData();
        lblConfigLocation.setLayoutData((Object)gridData);
        Composite locationComposite = new Composite(contents, 0);
        locationComposite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        locationComposite.setLayout((Layout)layout);
        this.mLocation = new Text(locationComposite, 18436);
        gridData = new GridData(768);
        this.mLocation.setLayoutData((Object)gridData);
        this.mBtnBrowse = new Button(locationComposite, 8);
        this.mBtnBrowse.setText(Messages.FileConfigurationLocationEditor_btnBrowse);
        gridData = new GridData();
        this.mBtnBrowse.setLayoutData((Object)gridData);
        this.mBtnBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(shell);
                fileDialog.setFileName(ExternalFileConfigurationEditor.this.mLocation.getText());
                String file = fileDialog.open();
                if (file != null) {
                    ExternalFileConfigurationEditor.this.mLocation.setText(file);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblDescription = new Label(contents, 0);
        lblDescription.setText(Messages.CheckConfigurationPropertiesDialog_lblDescription);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        lblDescription.setLayoutData((Object)gridData);
        this.mDescription = new Text(contents, 19010);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        gridData.heightHint = 100;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.mDescription.setLayoutData((Object)gridData);
        Group advancedGroup = new Group(contents, 0);
        advancedGroup.setText(Messages.RemoteConfigurationEditor_titleAdvancedOptions);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        advancedGroup.setLayoutData((Object)gridData);
        advancedGroup.setLayout((Layout)new GridLayout(2, false));
        this.mChkProtectConfig = new Button((Composite)advancedGroup, 32);
        this.mChkProtectConfig.setText(Messages.ExternalFileConfigurationEditor_btnProtectConfigFile);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mChkProtectConfig.setLayoutData((Object)gridData);
        if (this.mWorkingCopy.getName() != null) {
            this.mConfigName.setText(this.mWorkingCopy.getName());
        }
        if (this.mWorkingCopy.getLocation() != null) {
            this.mLocation.setText(this.mWorkingCopy.getLocation());
        }
        if (this.mWorkingCopy.getDescription() != null) {
            this.mDescription.setText(this.mWorkingCopy.getDescription());
        }
        this.mChkProtectConfig.setSelection(Boolean.parseBoolean((String)this.mWorkingCopy.getAdditionalData().get("protect-config-file")));
        return contents;
    }

    @Override
    public CheckConfigurationWorkingCopy getEditedWorkingCopy() throws CheckstylePluginException {
        this.mWorkingCopy.setName(this.mConfigName.getText());
        this.mWorkingCopy.setDescription(this.mDescription.getText());
        this.mWorkingCopy.getAdditionalData().put("protect-config-file", "" + this.mChkProtectConfig.getSelection());
        try {
            this.mWorkingCopy.setLocation(this.mLocation.getText());
        }
        catch (CheckstylePluginException ex) {
            String location = this.mLocation.getText();
            if (StringUtils.isNotBlank((CharSequence)location) && this.ensureFileExists(location)) {
                this.mWorkingCopy.setLocation(this.mLocation.getText());
            }
            throw ex;
        }
        return this.mWorkingCopy;
    }

    private boolean ensureFileExists(String location) throws CheckstylePluginException {
        String resolvedLocation = ExternalFileConfigurationType.resolveDynamicLocation((String)location);
        File file = new File(resolvedLocation);
        if (!file.exists()) {
            boolean confirm = MessageDialog.openQuestion((Shell)this.mBtnBrowse.getShell(), (String)Messages.ExternalFileConfigurationEditor_titleFileDoesNotExist, (String)Messages.ExternalFileConfigurationEditor_msgFileDoesNotExist);
            if (confirm) {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                        ConfigurationWriter.writeNewConfiguration((OutputStream)out, (ICheckConfiguration)this.mWorkingCopy);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ioe) {
                    CheckstylePluginException.rethrow((Throwable)ioe);
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

