/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.widgets;

import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyMetadata;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.PropertiesContentAssistProcessor;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetAbstractBase;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contentassist.ContentAssistHandler;

public class ConfigPropertyWidgetFile
extends ConfigPropertyWidgetAbstractBase {
    private Composite mContents;
    private Text mTextWidget;
    private Button mBtnBrowse;

    public ConfigPropertyWidgetFile(Composite parent, ConfigProperty prop) {
        super(parent, prop);
    }

    @Override
    protected Control getValueWidget(Composite parent) {
        if (this.mContents == null) {
            this.mContents = new Composite(parent, 0);
            this.mContents.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.mContents.setLayout((Layout)layout);
            this.mTextWidget = new Text(this.mContents, 18436);
            GridData gridData = new GridData(768);
            this.mTextWidget.setLayoutData((Object)gridData);
            ContentAssistHandler.createHandlerForText((Text)this.mTextWidget, (SubjectControlContentAssistant)this.createContentAssistant());
            this.mBtnBrowse = new Button(this.mContents, 8);
            this.mBtnBrowse.setText(Messages.ConfigPropertyWidgetFile_btnBrowse0);
            this.mBtnBrowse.setLayoutData((Object)new GridData());
            this.mBtnBrowse.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fileDialog = new FileDialog(ConfigPropertyWidgetFile.this.mTextWidget.getShell());
                    fileDialog.setFileName(ConfigPropertyWidgetFile.this.mTextWidget.getText());
                    String file = fileDialog.open();
                    if (file != null) {
                        ConfigPropertyWidgetFile.this.mTextWidget.setText(file);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            String initValue = this.getInitValue();
            if (initValue != null) {
                this.mTextWidget.setText(initValue);
            }
        }
        return this.mContents;
    }

    @Override
    public String getValue() {
        String result = this.mTextWidget.getText();
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mTextWidget.setEnabled(enabled);
        this.mBtnBrowse.setEnabled(enabled);
    }

    @Override
    public void restorePropertyDefault() {
        ConfigPropertyMetadata metadata = this.getConfigProperty().getMetaData();
        String defaultValue = metadata.getOverrideDefault() != null ? metadata.getOverrideDefault() : metadata.getDefaultValue();
        this.mTextWidget.setText(defaultValue != null ? defaultValue : "");
    }

    private SubjectControlContentAssistant createContentAssistant() {
        SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
        contentAssistant.setRestoreCompletionProposalSize(CheckstyleUIPlugin.getDefault().getDialogSettings());
        PropertiesContentAssistProcessor processor = new PropertiesContentAssistProcessor();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        return contentAssistant;
    }
}

