/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.eclipsecs.core.projectconfig.FileMatchPattern;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.util.regex.RegexCompletionProposalFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileMatchPatternEditDialog
extends TitleAreaDialog {
    private Button mIncludeButton;
    private Text mFileMatchPatternText;
    private FileMatchPattern mPattern;

    public FileMatchPatternEditDialog(Shell parentShell, FileMatchPattern pattern) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.mPattern = pattern;
    }

    public FileMatchPattern getPattern() {
        return this.mPattern;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite dialog = new Composite(composite, 0);
        dialog.setLayoutData((Object)new GridData(1808));
        dialog.setLayout((Layout)new GridLayout(1, false));
        Label nameLabel = new Label(dialog, 0);
        nameLabel.setText(Messages.FileMatchPatternEditDialog_lblRegex);
        this.mFileMatchPatternText = new Text(dialog, 2052);
        this.mFileMatchPatternText.setLayoutData((Object)new GridData(768));
        this.mIncludeButton = new Button(dialog, 32);
        this.mIncludeButton.setText(Messages.FileMatchPatternEditDialog_chkIncludesFiles);
        this.mIncludeButton.setLayoutData((Object)new GridData());
        RegexCompletionProposalFactory.createForText(this.mFileMatchPatternText);
        if (this.mPattern != null) {
            this.mFileMatchPatternText.setText(this.mPattern.getMatchPattern());
            this.mIncludeButton.setSelection(this.mPattern.isIncludePattern());
        } else {
            this.mIncludeButton.setSelection(true);
        }
        this.setTitleImage(CheckstyleUIPluginImages.PLUGIN_LOGO.getImage());
        this.setTitle(Messages.FileMatchPatternEditDialog_title);
        this.setMessage(Messages.FileMatchPatternEditDialog_message);
        return dialog;
    }

    protected void okPressed() {
        String pattern = this.mFileMatchPatternText.getText();
        try {
            Pattern.compile(pattern);
            if (this.mPattern == null) {
                this.mPattern = new FileMatchPattern(pattern);
            } else {
                this.mPattern.setMatchPattern(pattern);
            }
            this.mPattern.setIsIncludePattern(this.mIncludeButton.getSelection());
        }
        catch (PatternSyntaxException | CheckstylePluginException ex) {
            this.setErrorMessage(ex.getLocalizedMessage());
            return;
        }
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.FileMatchPatternEditDialog_titleRegexEditor);
    }
}

