/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties;

import java.util.List;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.projectconfig.FileMatchPattern;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationConfigureDialog;
import net.sf.eclipsecs.ui.config.CheckConfigurationLabelProvider;
import net.sf.eclipsecs.ui.config.CheckConfigurationViewerSorter;
import net.sf.eclipsecs.ui.properties.CheckConfigurationContentProvider;
import net.sf.eclipsecs.ui.properties.CheckstylePropertyPage;
import net.sf.eclipsecs.ui.properties.IFileSetsEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SimpleFileSetsEditor
implements IFileSetsEditor {
    private final CheckstylePropertyPage mPropertyPage;
    private ComboViewer mComboViewer;
    private Text mTxtConfigDescription;
    private Button mBtnManageConfigs;
    private List<FileSet> mFileSets;
    private FileSet mDefaultFileSet;
    private Controller mController;

    public SimpleFileSetsEditor(CheckstylePropertyPage propsPage) {
        this.mPropertyPage = propsPage;
    }

    @Override
    public void setFileSets(List<FileSet> fileSets) throws CheckstylePluginException {
        CheckConfigurationWorkingCopy[] allConfigs;
        this.mFileSets = fileSets;
        ICheckConfiguration config = null;
        if (this.mFileSets.size() > 0) {
            config = this.mFileSets.get(0).getCheckConfig();
        }
        if (config == null && (allConfigs = this.mPropertyPage.getProjectConfigurationWorkingCopy().getGlobalCheckConfigWorkingSet().getWorkingCopies()).length > 0) {
            config = allConfigs[0];
        }
        this.mDefaultFileSet = new FileSet(Messages.SimpleFileSetsEditor_nameAllFileset, config);
        this.mDefaultFileSet.getFileMatchPatterns().add(new FileMatchPattern("."));
        this.mFileSets.clear();
        this.mFileSets.add(this.mDefaultFileSet);
    }

    @Override
    public List<FileSet> getFileSets() {
        return this.mFileSets;
    }

    @Override
    public Control createContents(Composite parent) throws CheckstylePluginException {
        this.mController = new Controller();
        Group configArea = new Group(parent, 0);
        configArea.setText(Messages.SimpleFileSetsEditor_titleSimpleConfig);
        configArea.setLayout((Layout)new FormLayout());
        this.mBtnManageConfigs = new Button((Composite)configArea, 8);
        this.mBtnManageConfigs.setText(Messages.SimpleFileSetsEditor_btnManageConfigs);
        this.mBtnManageConfigs.addSelectionListener((SelectionListener)this.mController);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 3);
        formData.right = new FormAttachment(100, -3);
        this.mBtnManageConfigs.setLayoutData((Object)formData);
        this.mComboViewer = new ComboViewer((Composite)configArea);
        this.mComboViewer.getCombo().setVisibleItemCount(10);
        this.mComboViewer.setContentProvider((IContentProvider)new CheckConfigurationContentProvider());
        this.mComboViewer.setLabelProvider((IBaseLabelProvider)new CheckConfigurationLabelProvider());
        this.mComboViewer.setComparator((ViewerComparator)new CheckConfigurationViewerSorter());
        this.mComboViewer.getControl().setLayoutData((Object)new GridData(768));
        this.mComboViewer.addSelectionChangedListener((ISelectionChangedListener)this.mController);
        formData = new FormData();
        formData.left = new FormAttachment(0, 3);
        formData.top = new FormAttachment(0, 3);
        formData.right = new FormAttachment((Control)this.mBtnManageConfigs, -3, 16384);
        this.mComboViewer.getCombo().setLayoutData((Object)formData);
        Label lblConfigDesc = new Label((Composite)configArea, 16384);
        lblConfigDesc.setText(Messages.SimpleFileSetsEditor_lblDescription);
        formData = new FormData();
        formData.left = new FormAttachment(0, 3);
        formData.top = new FormAttachment((Control)this.mComboViewer.getCombo(), 3, 1024);
        formData.right = new FormAttachment(100, -3);
        lblConfigDesc.setLayoutData((Object)formData);
        this.mTxtConfigDescription = new Text((Composite)configArea, 19018);
        formData = new FormData();
        formData.left = new FormAttachment(0, 3);
        formData.top = new FormAttachment((Control)lblConfigDesc, 0, 1024);
        formData.right = new FormAttachment(100, -3);
        formData.bottom = new FormAttachment(100, -3);
        this.mTxtConfigDescription.setLayoutData((Object)formData);
        this.mComboViewer.setInput((Object)this.mPropertyPage.getProjectConfigurationWorkingCopy());
        if (this.mDefaultFileSet.getCheckConfig() != null) {
            this.mComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.mDefaultFileSet.getCheckConfig()));
        }
        return configArea;
    }

    @Override
    public void refresh() {
        this.mComboViewer.refresh();
    }

    private class Controller
    implements SelectionListener,
    ISelectionChangedListener {
        private Controller() {
        }

        public void widgetSelected(SelectionEvent e) {
            ICheckConfiguration config;
            if (SimpleFileSetsEditor.this.mBtnManageConfigs == e.widget && (config = SimpleFileSetsEditor.this.mDefaultFileSet.getCheckConfig()) != null) {
                IProject project = (IProject)SimpleFileSetsEditor.this.mPropertyPage.getElement();
                try {
                    config.getCheckstyleConfiguration();
                    CheckConfigurationWorkingCopy workingCopy = (CheckConfigurationWorkingCopy)config;
                    CheckConfigurationConfigureDialog dialog = new CheckConfigurationConfigureDialog(SimpleFileSetsEditor.this.mTxtConfigDescription.getShell(), workingCopy);
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                }
                catch (CheckstylePluginException ex) {
                    CheckstyleUIPlugin.warningDialog(SimpleFileSetsEditor.this.mPropertyPage.getShell(), NLS.bind((String)Messages.CheckstylePreferencePage_msgProjectRelativeConfigNoFound, (Object)project, (Object)config.getLocation()), ex);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            ICheckConfiguration config = (ICheckConfiguration)selection.getFirstElement();
            if (config != null) {
                SimpleFileSetsEditor.this.mDefaultFileSet.setCheckConfig(config);
                SimpleFileSetsEditor.this.mTxtConfigDescription.setText(config.getDescription() != null ? config.getDescription() : "");
            } else {
                SimpleFileSetsEditor.this.mComboViewer.setSelection((ISelection)new StructuredSelection(SimpleFileSetsEditor.this.mComboViewer.getElementAt(0)));
            }
            SimpleFileSetsEditor.this.mPropertyPage.getContainer().updateButtons();
        }
    }
}

