/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties.filter;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.jobs.RunCheckstyleOnFilesJob;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import net.sf.eclipsecs.core.projectconfig.filters.UnOpenedFilesFilter;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.FileEditorInput;

public class CheckFileOnOpenPartListener
implements IPartListener2 {
    public void partsOpened(Collection<IWorkbenchPartReference> parts) {
        new PartsOpenedJob(parts).schedule();
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.partsOpened(Collections.singleton(partRef));
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IFile editorFile = this.getEditorFile(partRef);
        if (editorFile != null) {
            UnOpenedFilesFilter.removeOpenedFile((IFile)editorFile);
        }
        if (editorFile != null && this.isFileAffected(editorFile)) {
            try {
                editorFile.deleteMarkers("net.sf.eclipsecs.core.CheckstyleMarker", true, 2);
            }
            catch (CoreException ex) {
                CheckstyleLog.log((Throwable)ex);
            }
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    private IFile getEditorFile(IWorkbenchPartReference partRef) {
        if (!(partRef instanceof IEditorReference)) {
            return null;
        }
        IFile file = null;
        IWorkbenchPart part = partRef.getPart(false);
        IEditorInput input = null;
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            input = editor.getEditorInput();
        } else {
            IEditorReference editRef = (IEditorReference)partRef;
            input = this.getRestoredInput(editRef);
        }
        if (input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        }
        return file;
    }

    private IEditorInput getRestoredInput(IEditorReference editorRef) {
        IMemento editorMem = null;
        editorMem = CheckstyleUIPlugin.isE3() ? this.getMementoE3(editorRef) : this.getMementoE4(editorRef);
        if (editorMem == null) {
            return null;
        }
        IMemento inputMem = editorMem.getChild("input");
        String factoryID = null;
        if (inputMem != null) {
            factoryID = inputMem.getString("factoryID");
        }
        if (factoryID == null) {
            return null;
        }
        IAdaptable input = null;
        IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
        if (factory == null) {
            return null;
        }
        input = factory.createElement(inputMem);
        if (input == null) {
            return null;
        }
        if (!(input instanceof IEditorInput)) {
            return null;
        }
        return (IEditorInput)input;
    }

    private IMemento getMementoE4(IEditorReference editorRef) {
        try {
            Method getModelMethod = editorRef.getClass().getMethod("getModel", new Class[0]);
            getModelMethod.setAccessible(true);
            Object model = getModelMethod.invoke((Object)editorRef, null);
            Method getPersistedStateMethod = model.getClass().getMethod("getPersistedState", new Class[0]);
            getPersistedStateMethod.setAccessible(true);
            Map state = (Map)getPersistedStateMethod.invoke(model, null);
            String memento = (String)state.get("memento");
            if (memento != null) {
                try {
                    return XMLMemento.createReadRoot((Reader)new StringReader(memento));
                }
                catch (WorkbenchException ex) {
                    CheckstyleLog.log((Throwable)ex);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            CheckstyleLog.log((Throwable)ex);
        }
        return null;
    }

    private IMemento getMementoE3(IEditorReference editorRef) {
        try {
            Method getMementoMethod = editorRef.getClass().getMethod("getMemento", new Class[0]);
            getMementoMethod.setAccessible(true);
            IMemento memento = (IMemento)getMementoMethod.invoke((Object)editorRef, null);
            return memento;
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            CheckstyleLog.log((Throwable)ex);
            return null;
        }
    }

    private boolean isFileAffected(IFile file) {
        boolean affected = false;
        IProject project = file.getProject();
        try {
            if (project.isAccessible() && project.hasNature("net.sf.eclipsecs.core.CheckstyleNature")) {
                IProjectConfiguration config = ProjectConfigurationFactory.getConfiguration((IProject)project);
                boolean unOpenedFilesFilterActive = false;
                boolean filtered = false;
                List filters = config.getFilters();
                for (IFilter filter : filters) {
                    if (filter instanceof UnOpenedFilesFilter && ((UnOpenedFilesFilter)filter).isEnabled()) {
                        unOpenedFilesFilterActive = true;
                    }
                    if (!filter.isEnabled() || filter instanceof UnOpenedFilesFilter) continue;
                    boolean bl = filtered = filtered || !filter.accept((Object)file);
                }
                affected = unOpenedFilesFilterActive && !filtered;
            }
        }
        catch (CheckstylePluginException | CoreException ex) {
            CheckstyleLog.log((Throwable)ex);
        }
        return affected;
    }

    private class PartsOpenedJob
    extends WorkspaceJob
    implements ISchedulingRule {
        private Collection<IWorkbenchPartReference> mParts;

        public PartsOpenedJob(Collection<IWorkbenchPartReference> parts) {
            super(Messages.RunCheckstyleOnFilesJob_title);
            this.mParts = parts;
        }

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return false;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            ArrayList<IFile> filesToCheck = new ArrayList<IFile>();
            for (IWorkbenchPartReference partRef : this.mParts) {
                IFile editorFile = CheckFileOnOpenPartListener.this.getEditorFile(partRef);
                if (editorFile != null) {
                    UnOpenedFilesFilter.addOpenedFile((IFile)editorFile);
                }
                if (editorFile == null || !CheckFileOnOpenPartListener.this.isFileAffected(editorFile)) continue;
                filesToCheck.add(editorFile);
            }
            RunCheckstyleOnFilesJob job = new RunCheckstyleOnFilesJob(filesToCheck);
            job.schedule();
            return Status.OK_STATUS;
        }
    }
}

