/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties.marker;

import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.config.meta.RuleMetadata;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationConfigureDialog;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class MarkerPropertyPage
extends PropertyPage {
    private IMarker getIssue() {
        return (IMarker)this.getElement();
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        try {
            new Label(composite, 0).setImage(MarkerPropertyPage.getSeverityImage(this.getIssue().getAttribute("severity", -1)));
            new Label(composite, 0).setText(Messages.MarkerPropertyPage_Issue);
            String message = (String)this.getIssue().getAttribute("message");
            Label labelMessage = new Label(composite, 0);
            labelMessage.setText(message);
            new Label(composite, 0).setImage(CheckstyleUIPluginImages.MODULEGROUP_ICON.getImage());
            new Label(composite, 0).setText(Messages.MarkerPropertyPage_Group);
            String moduleName = (String)this.getIssue().getAttribute("ModuleName");
            RuleMetadata metaData = MetadataFactory.getRuleMetadata((String)moduleName);
            new Label(composite, 0).setText(metaData.getGroup().getGroupName());
            new Label(composite, 0).setImage(CheckstyleUIPluginImages.MODULE_ICON.getImage());
            new Label(composite, 0).setText(Messages.MarkerPropertyPage_Module);
            RowLayout rowLayout = new RowLayout(256);
            rowLayout.marginLeft = 0;
            rowLayout.marginTop = 0;
            rowLayout.marginBottom = 0;
            rowLayout.marginRight = 0;
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setLayout((Layout)rowLayout);
            new Label(nameComposite, 0).setText(metaData.getRuleName());
            Label helpIcon = new Label(nameComposite, 0);
            helpIcon.setImage(CheckstyleUIPluginImages.HELP_ICON.getImage());
            helpIcon.setToolTipText(NLS.bind((String)Messages.MarkerPropertyPage_SuppressionHint, (Object)metaData.getInternalName()));
            Label descriptionLabel = new Label(composite, 0);
            descriptionLabel.setText(Messages.MarkerPropertyPage_Description);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.verticalIndent = 20;
            descriptionLabel.setLayoutData((Object)gridData);
            gridData = new GridData(1808);
            gridData.heightHint = 100;
            gridData.horizontalSpan = 3;
            Browser browserDescription = new Browser(composite, 2048);
            browserDescription.setLayoutData((Object)gridData);
            browserDescription.setText(CheckConfigurationConfigureDialog.getDescriptionHtml(metaData.getDescription()));
        }
        catch (CoreException ex) {
            CheckstyleLog.log((Throwable)ex);
        }
        return composite;
    }

    public static Image getSeverityImage(int severity) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        switch (severity) {
            case 2: {
                return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
            }
            case 1: {
                return sharedImages.getImage("IMG_OBJS_WARN_TSK");
            }
            case 0: {
                return sharedImages.getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }
}

