/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes;

import java.util.ArrayList;
import java.util.List;
import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.config.meta.RuleMetadata;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.quickfixes.ICheckstyleMarkerResolution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class CheckstyleMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<ICheckstyleMarkerResolution> fixes = new ArrayList<ICheckstyleMarkerResolution>();
        String moduleName = marker.getAttribute("ModuleName", null);
        RuleMetadata metadata = MetadataFactory.getRuleMetadata((String)moduleName);
        List<ICheckstyleMarkerResolution> potentialFixes = this.getInstantiatedQuickfixes(metadata);
        for (ICheckstyleMarkerResolution fix : potentialFixes) {
            if (!fix.canFix(marker)) continue;
            fixes.add(fix);
        }
        return (IMarkerResolution[])fixes.toArray(new ICheckstyleMarkerResolution[fixes.size()]);
    }

    public boolean hasResolutions(IMarker marker) {
        boolean hasAtLeastOneFix = false;
        String moduleName = marker.getAttribute("ModuleName", null);
        RuleMetadata metadata = MetadataFactory.getRuleMetadata((String)moduleName);
        if (metadata != null) {
            List<ICheckstyleMarkerResolution> fixes = this.getInstantiatedQuickfixes(metadata);
            for (ICheckstyleMarkerResolution fix : fixes) {
                if (!fix.canFix(marker)) continue;
                hasAtLeastOneFix = true;
                break;
            }
        }
        return hasAtLeastOneFix;
    }

    private List<ICheckstyleMarkerResolution> getInstantiatedQuickfixes(RuleMetadata ruleMetadata) {
        ArrayList<ICheckstyleMarkerResolution> fixes = new ArrayList<ICheckstyleMarkerResolution>();
        try {
            for (String quickfixClassName : ruleMetadata.getQuickfixClassNames()) {
                Class<?> quickfixClass = CheckstyleUIPlugin.getDefault().getQuickfixExtensionClassLoader().loadClass(quickfixClassName);
                ICheckstyleMarkerResolution fix = (ICheckstyleMarkerResolution)quickfixClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                fix.setRuleMetaData(ruleMetadata);
                fixes.add(fix);
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            CheckstyleLog.log((Throwable)ex);
        }
        return fixes;
    }
}

