/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.blocks;

import java.util.List;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class AvoidNestedBlocksQuickfix
extends AbstractASTResolution {
    @Override
    protected ASTVisitor handleGetCorrectingASTVisitor(final IRegion lineInfo, int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(Block node) {
                if (AvoidNestedBlocksQuickfix.this.containsPosition(lineInfo, node.getStartPosition())) {
                    if (node.getParent() instanceof Block) {
                        List statements = ((Block)node.getParent()).statements();
                        int index = statements.indexOf(node);
                        statements.remove(node);
                        statements.addAll(index, ASTNode.copySubtrees((AST)node.getAST(), (List)node.statements()));
                    } else if (node.getParent() instanceof SwitchStatement) {
                        List statements = ((SwitchStatement)node.getParent()).statements();
                        int index = statements.indexOf(node);
                        statements.remove(node);
                        statements.addAll(index, ASTNode.copySubtrees((AST)node.getAST(), (List)node.statements()));
                    }
                }
                return true;
            }
        };
    }

    public String getDescription() {
        return Messages.AvoidNextedBlocksQuickfix_description;
    }

    public String getLabel() {
        return Messages.AvoidNextedBlocksQuickfix_label;
    }

    @Override
    public Image getImage() {
        return CheckstyleUIPluginImages.CORRECTION_REMOVE.getImage();
    }
}

