/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.coding;

import java.util.ArrayList;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class DefaultComesLastQuickfix
extends AbstractASTResolution {
    @Override
    protected ASTVisitor handleGetCorrectingASTVisitor(final IRegion lineInfo, int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(SwitchCase node) {
                if (DefaultComesLastQuickfix.this.containsPosition(lineInfo, node.getStartPosition()) && node.isDefault() && !this.isLastSwitchCase(node)) {
                    SwitchStatement switchStatement = (SwitchStatement)node.getParent();
                    ArrayList<Object> defaultCaseStatements = new ArrayList<Object>();
                    defaultCaseStatements.add(node);
                    int defaultStatementIndex = switchStatement.statements().indexOf(node);
                    int i = defaultStatementIndex + 1;
                    while (i < switchStatement.statements().size()) {
                        ASTNode tmpNode = (ASTNode)switchStatement.statements().get(i);
                        if (tmpNode instanceof SwitchCase) break;
                        defaultCaseStatements.add(tmpNode);
                        ++i;
                    }
                    switchStatement.statements().removeAll(defaultCaseStatements);
                    switchStatement.statements().addAll(defaultCaseStatements);
                }
                return true;
            }

            private boolean isLastSwitchCase(SwitchCase switchCase) {
                SwitchStatement switchStatement = (SwitchStatement)switchCase.getParent();
                int defaultStatementIndex = switchStatement.statements().indexOf(switchCase);
                int i = defaultStatementIndex + 1;
                while (i < switchStatement.statements().size()) {
                    ASTNode tmpNode = (ASTNode)switchStatement.statements().get(i);
                    if (tmpNode instanceof SwitchCase) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
    }

    public String getDescription() {
        return Messages.DefaultComesLastQuickfix_description;
    }

    public String getLabel() {
        return Messages.DefaultComesLastQuickfix_label;
    }

    @Override
    public Image getImage() {
        return CheckstyleUIPluginImages.CORRECTION_CHANGE.getImage();
    }
}

