/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.design;

import java.util.List;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import net.sf.eclipsecs.ui.quickfixes.modifier.ModifierOrderQuickfix;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class DesignForExtensionQuickfix
extends AbstractASTResolution {
    private static final int JAVADOC_COMMENT_LENGTH = 6;

    @Override
    protected ASTVisitor handleGetCorrectingASTVisitor(final IRegion lineInfo, int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                int pos = node.getStartPosition() + (node.getJavadoc() != null ? node.getJavadoc().getLength() + 6 : 0);
                if (DesignForExtensionQuickfix.this.containsPosition(lineInfo, pos) && !Modifier.isFinal((int)node.getModifiers())) {
                    Modifier finalModifier = node.getAST().newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                    node.modifiers().add(finalModifier);
                    List<ASTNode> reorderedModifiers = ModifierOrderQuickfix.reOrderModifiers(node.modifiers());
                    node.modifiers().clear();
                    node.modifiers().addAll(reorderedModifiers);
                }
                return true;
            }
        };
    }

    public String getDescription() {
        return Messages.DesignForExtensionQuickfix_description;
    }

    public String getLabel() {
        return Messages.DesignForExtensionQuickfix_label;
    }

    @Override
    public Image getImage() {
        return CheckstyleUIPluginImages.CORRECTION_ADD.getImage();
    }
}

