/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.modifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class ModifierOrderQuickfix
extends AbstractASTResolution {
    private static final List<Object> MODIFIER_ORDER = Arrays.asList(Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.PROTECTED_KEYWORD, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD, Modifier.ModifierKeyword.VOLATILE_KEYWORD, Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD, Modifier.ModifierKeyword.NATIVE_KEYWORD, Modifier.ModifierKeyword.STRICTFP_KEYWORD, Modifier.ModifierKeyword.DEFAULT_KEYWORD);

    public static List<ASTNode> reOrderModifiers(List<ASTNode> modifiers) {
        ArrayList<ASTNode> copies = new ArrayList<ASTNode>();
        for (ASTNode mod : modifiers) {
            copies.add(ASTNode.copySubtree((AST)mod.getAST(), (ASTNode)mod));
        }
        Collections.sort(copies, new Comparator<ASTNode>(){

            @Override
            public int compare(ASTNode arg0, ASTNode arg1) {
                if (!(arg0 instanceof Modifier) || !(arg1 instanceof Modifier)) {
                    return 0;
                }
                Modifier modifier1 = (Modifier)arg0;
                Modifier modifier2 = (Modifier)arg1;
                int modifierIndex1 = MODIFIER_ORDER.indexOf(modifier1.getKeyword());
                int modifierIndex2 = MODIFIER_ORDER.indexOf(modifier2.getKeyword());
                return Integer.valueOf(modifierIndex1).compareTo(modifierIndex2);
            }
        });
        return copies;
    }

    @Override
    protected ASTVisitor handleGetCorrectingASTVisitor(IRegion lineInfo, final int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                return this.visitBodyDecl((BodyDeclaration)node);
            }

            public boolean visit(MethodDeclaration node) {
                return this.visitBodyDecl((BodyDeclaration)node);
            }

            public boolean visit(FieldDeclaration node) {
                return this.visitBodyDecl((BodyDeclaration)node);
            }

            public boolean visit(AnnotationTypeMemberDeclaration node) {
                return this.visitBodyDecl((BodyDeclaration)node);
            }

            private boolean visitBodyDecl(BodyDeclaration node) {
                List modifiers = node.modifiers().stream().filter(Modifier.class::isInstance).map(Modifier.class::cast).collect(Collectors.toList());
                if (modifiers == null || modifiers.isEmpty()) {
                    return true;
                }
                int minPos = modifiers.stream().mapToInt(ASTNode::getStartPosition).min().getAsInt();
                int maxPos = modifiers.stream().mapToInt(ASTNode::getStartPosition).max().getAsInt();
                if (minPos <= markerStartOffset && markerStartOffset <= maxPos) {
                    List<ASTNode> reorderedModifiers = ModifierOrderQuickfix.reOrderModifiers(node.modifiers());
                    node.modifiers().clear();
                    node.modifiers().addAll(reorderedModifiers);
                }
                return true;
            }
        };
    }

    public String getDescription() {
        return Messages.ModifierOrderQuickfix_description;
    }

    public String getLabel() {
        return Messages.ModifierOrderQuickfix_label;
    }

    @Override
    public Image getImage() {
        return CheckstyleUIPluginImages.CORRECTION_CHANGE.getImage();
    }
}

