/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.modifier;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class RedundantModifierQuickfix
extends AbstractASTResolution {
    private static final int JAVADOC_COMMENT_LENGTH = 6;

    @Override
    protected ASTVisitor handleGetCorrectingASTVisitor(final IRegion lineInfo, final int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                if (RedundantModifierQuickfix.this.containsPosition((ASTNode)node, markerStartOffset)) {
                    List<Modifier.ModifierKeyword> redundantKeyWords = Collections.emptyList();
                    if (node.getParent() instanceof TypeDeclaration) {
                        TypeDeclaration type = (TypeDeclaration)node.getParent();
                        if (type.isInterface()) {
                            redundantKeyWords = Arrays.asList(Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
                        } else if (Modifier.isFinal((int)type.getModifiers())) {
                            redundantKeyWords = Arrays.asList(Modifier.ModifierKeyword.FINAL_KEYWORD);
                        }
                    }
                    this.deleteRedundantModifiers(node.modifiers(), redundantKeyWords);
                }
                return true;
            }

            public boolean visit(FieldDeclaration node) {
                int pos = node.getStartPosition() + (node.getJavadoc() != null ? node.getJavadoc().getLength() + 6 : 0);
                if (RedundantModifierQuickfix.this.containsPosition(lineInfo, pos)) {
                    List<Modifier.ModifierKeyword> redundantKeyWords = Collections.emptyList();
                    if (node.getParent() instanceof TypeDeclaration) {
                        TypeDeclaration type = (TypeDeclaration)node.getParent();
                        if (type.isInterface()) {
                            redundantKeyWords = Arrays.asList(Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
                        }
                    } else if (node.getParent() instanceof AnnotationTypeDeclaration) {
                        redundantKeyWords = Arrays.asList(Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
                    }
                    this.deleteRedundantModifiers(node.modifiers(), redundantKeyWords);
                }
                return true;
            }

            public boolean visit(AnnotationTypeMemberDeclaration node) {
                int pos = node.getStartPosition() + (node.getJavadoc() != null ? node.getJavadoc().getLength() + 6 : 0);
                if (RedundantModifierQuickfix.this.containsPosition(lineInfo, pos) && node.getParent() instanceof AnnotationTypeDeclaration) {
                    List<Modifier.ModifierKeyword> redundantKeyWords = Arrays.asList(Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
                    this.deleteRedundantModifiers(node.modifiers(), redundantKeyWords);
                }
                return true;
            }

            private void deleteRedundantModifiers(List<ASTNode> modifiers, List<Modifier.ModifierKeyword> redundantModifierKeywords) {
                Iterator<ASTNode> iter = modifiers.iterator();
                while (iter.hasNext()) {
                    Modifier modifier;
                    ASTNode node = iter.next();
                    if (!(node instanceof Modifier) || !redundantModifierKeywords.contains((modifier = (Modifier)node).getKeyword())) continue;
                    iter.remove();
                }
            }
        };
    }

    public String getDescription() {
        return Messages.RedundantModifierQuickfix_description;
    }

    public String getLabel() {
        return Messages.RedundantModifierQuickfix_label;
    }

    @Override
    public Image getImage() {
        return CheckstyleUIPluginImages.CORRECTION_REMOVE.getImage();
    }
}

