/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.stats.data;

import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Pattern;
import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.ui.stats.Messages;
import net.sf.eclipsecs.ui.stats.data.MarkerStat;
import net.sf.eclipsecs.ui.stats.data.Stats;
import net.sf.eclipsecs.ui.stats.views.internal.CheckstyleMarkerFilter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CreateStatsJob
extends Job {
    private static final Pattern REGEXP_HOLES = Pattern.compile("\\{[0-9]+(\\S)*\\}");
    private static final Pattern REGEXP_QUOTE = Pattern.compile("'+");
    private final CheckstyleMarkerFilter mFilter;
    private final String mFamily;
    private Stats mStats;

    public CreateStatsJob(CheckstyleMarkerFilter filter, String family) {
        super(Messages.CreateStatsJob_msgAnalyzeMarkers);
        this.mFilter = (CheckstyleMarkerFilter)filter.clone();
        this.mFamily = family;
    }

    public boolean shouldSchedule() {
        Job[] similarJobs = CreateStatsJob.getJobManager().find((Object)this.mFamily);
        return similarJobs.length == 0;
    }

    public boolean belongsTo(Object family) {
        return Objects.equals(this.mFamily, family);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            int wholeAmountOfMarkers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("net.sf.eclipsecs.core.CheckstyleMarker", true, 2).length;
            IMarker[] markers = this.mFilter.findMarkers(monitor);
            HashMap<String, MarkerStat> markerStats = new HashMap<String, MarkerStat>();
            int i = 0;
            int size = markers.length;
            while (i < size) {
                String message = null;
                try {
                    message = CreateStatsJob.getUnlocalizedMessage(markers[i]);
                    message = CreateStatsJob.cleanMessage(message);
                }
                catch (CoreException ex) {
                    CheckstyleLog.log((Throwable)ex, (String)Messages.CreateStatsJob_errorAnalyzingMarkers);
                }
                if (message == null || message.trim().length() == 0) {
                    CheckstyleLog.log(null, (String)Messages.CreateStatsJob_markerMessageShouldntBeEmpty);
                } else {
                    MarkerStat stat = (MarkerStat)markerStats.get(message);
                    if (stat == null) {
                        MarkerStat newMarkerStat = new MarkerStat(message);
                        newMarkerStat.addMarker(markers[i]);
                        markerStats.put(newMarkerStat.getIdentifiant(), newMarkerStat);
                    } else {
                        stat.addMarker(markers[i]);
                    }
                }
                ++i;
            }
            this.mStats = new Stats(markerStats.values(), markers.length, wholeAmountOfMarkers);
        }
        catch (CoreException ex) {
            return new Status(4, "net.sf.eclipsecs.ui", 0, Messages.CreateStatsJob_errorAnalyzingMarkers, (Throwable)ex);
        }
        return Status.OK_STATUS;
    }

    public Stats getStats() {
        return this.mStats;
    }

    public static String getUnlocalizedMessage(IMarker marker) throws CoreException {
        String moduleInternalName;
        String key = (String)marker.getAttribute("MessageKey");
        String standardMessage = MetadataFactory.getStandardMessage((String)key, (String)(moduleInternalName = (String)marker.getAttribute("ModuleName")));
        if (standardMessage == null) {
            standardMessage = (String)marker.getAttribute("message");
        }
        return standardMessage;
    }

    public static String cleanMessage(String message) {
        String finalMessage = REGEXP_HOLES.matcher(message).replaceAll("X");
        finalMessage = REGEXP_QUOTE.matcher(finalMessage).replaceAll("'");
        return finalMessage;
    }
}

