/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.stats.data;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class MarkerStat
implements Comparable<MarkerStat> {
    private String mIdentifiant;
    private Collection<IMarker> mMarkers;
    private int mMaxSeverity;

    public MarkerStat(String identifiant) {
        this.mIdentifiant = identifiant;
        this.mMarkers = new ArrayList<IMarker>();
    }

    public void addMarker(IMarker marker) {
        this.mMarkers.add(marker);
        int severity = MarkerUtilities.getSeverity((IMarker)marker);
        if (severity > this.mMaxSeverity) {
            this.mMaxSeverity = severity;
        }
    }

    @Override
    public int compareTo(MarkerStat stat) {
        return this.mIdentifiant.compareTo(stat.getIdentifiant());
    }

    public Collection<IMarker> getMarkers() {
        return this.mMarkers;
    }

    public int getCount() {
        return this.mMarkers.size();
    }

    public int getMaxSeverity() {
        return this.mMaxSeverity;
    }

    public String getIdentifiant() {
        return this.mIdentifiant;
    }
}

