/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.builder;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.CheckstylePluginPrefs;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.IContextAware;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.InputSource;

public final class CheckerFactory {
    private static Cache<String, Checker> sCheckerMap = CacheBuilder.newBuilder().softValues().build();
    private static Map<String, Long> sModifiedMap = new ConcurrentHashMap<String, Long>();

    private CheckerFactory() {
    }

    public static Checker createChecker(ICheckConfiguration config, IProject project) throws CheckstyleException, CheckstylePluginException {
        CheckstyleConfigurationFile configFileData;
        String cacheKey = CheckerFactory.getCacheKey(config, project);
        Checker checker = CheckerFactory.tryCheckerCache(cacheKey, (configFileData = config.getCheckstyleConfiguration()).getModificationStamp());
        if (checker != null) {
            checker.clearCache();
        }
        if (checker == null) {
            PropertyResolver resolver = configFileData.getPropertyResolver();
            if (resolver instanceof IContextAware) {
                ((IContextAware)resolver).setProjectContext(project);
            }
            InputSource input = null;
            try {
                input = configFileData.getCheckConfigFileInputSource();
                checker = CheckerFactory.createCheckerInternal(input, resolver, project);
            }
            finally {
                Closeables.closeQuietly((InputStream)input.getByteStream());
            }
            Long modified = configFileData.getModificationStamp();
            sCheckerMap.put((Object)cacheKey, (Object)checker);
            sModifiedMap.put(cacheKey, modified);
        } else {
            CheckerFactory.setLocaleIfChanged(checker);
        }
        return checker;
    }

    public static void cleanup() {
        sCheckerMap.invalidateAll();
        sModifiedMap.clear();
    }

    private static String getCacheKey(ICheckConfiguration config, IProject project) throws CheckstylePluginException {
        CheckstyleConfigurationFile configFileData = config.getCheckstyleConfiguration();
        URL configLocation = configFileData.getResolvedConfigFileURL();
        String checkConfigName = String.valueOf(config.getName()) + "#" + (config.isGlobal() ? "Global" : "Local");
        String cacheKey = String.valueOf(project.getName()) + "#" + configLocation + "#" + checkConfigName;
        return cacheKey;
    }

    private static Checker tryCheckerCache(String cacheKey, long modificationStamp) {
        Checker checker = (Checker)sCheckerMap.getIfPresent((Object)cacheKey);
        if (checker != null) {
            Long oldTime = sModifiedMap.get(cacheKey);
            Long newTime = modificationStamp;
            if (oldTime == null || oldTime.compareTo(newTime) != 0) {
                checker = null;
                sCheckerMap.invalidate((Object)cacheKey);
                sModifiedMap.remove(cacheKey);
            }
        }
        return checker;
    }

    private static Checker createCheckerInternal(InputSource input, PropertyResolver propResolver, IProject project) throws CheckstyleException, CheckstylePluginException {
        Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)input, (PropertyResolver)propResolver, (ConfigurationLoader.IgnoredModulesOptions)ConfigurationLoader.IgnoredModulesOptions.OMIT);
        ClassLoader moduleClassLoader = CheckstylePlugin.getDefault().getAddonExtensionClassLoader();
        Set packageNames = PackageNamesLoader.getPackageNames((ClassLoader)moduleClassLoader);
        Checker checker = new Checker();
        checker.setModuleFactory((ModuleFactory)new PackageObjectFactory(packageNames, moduleClassLoader, PackageObjectFactory.ModuleLoadOption.TRY_IN_ALL_REGISTERED_PACKAGES));
        try {
            checker.setCharset(project.getDefaultCharset());
        }
        catch (UnsupportedEncodingException | CoreException ex) {
            CheckstylePluginException.rethrow(ex);
        }
        CheckerFactory.setLocale(checker, CheckerFactory.getLocale());
        checker.configure(configuration);
        checker.setBasedir(null);
        return checker;
    }

    private static void setLocaleIfChanged(Checker checker) {
        String lc = CheckerFactory.getLocale();
        if (lc != null && !lc.equals(CheckstylePlugin.getPlatformLocale().getLanguage())) {
            CheckerFactory.setLocale(checker, lc);
        }
    }

    private static void setLocale(Checker checker, String lang) {
        if (lang != null) {
            String lastLocale = lang;
            checker.setLocaleLanguage(lang);
            checker.setLocaleCountry("");
            Locale locale = new Locale(lang);
            LocalizedMessage.setLocale((Locale)locale);
            CheckstylePlugin.setPlatformLocale(locale);
        } else {
            Locale platformLocale = CheckstylePlugin.getPlatformLocale();
            String lastLocale = platformLocale.getLanguage();
            checker.setLocaleLanguage(lastLocale);
            checker.setLocaleCountry(platformLocale.getCountry());
            LocalizedMessage.setLocale((Locale)platformLocale);
        }
    }

    private static String getLocale() {
        String lang = CheckstylePluginPrefs.getString("checkstyle_rule_language");
        if (lang != null && (lang.isEmpty() || "default".equals(lang))) {
            lang = null;
        }
        return lang;
    }
}

