/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.Severity;
import net.sf.eclipsecs.core.config.savefilter.SaveFilters;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.core.util.XMLUtil;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class ConfigurationWriter {
    private ConfigurationWriter() {
    }

    public static void writeNewConfiguration(OutputStream out, ICheckConfiguration checkConfig) throws CheckstylePluginException {
        ConfigurationWriter.write(out, new ArrayList<Module>(), checkConfig);
    }

    public static void write(OutputStream out, List<Module> modules, ICheckConfiguration checkConfig) throws CheckstylePluginException {
        try {
            SaveFilters.process(modules);
            Document doc = DocumentHelper.createDocument();
            doc.addDocType("module", "-//Checkstyle//DTD Checkstyle Configuration 1.3//EN", "https://checkstyle.org/dtds/configuration_1_3.dtd");
            String lineSeperator = System.lineSeparator();
            String comment = String.valueOf(lineSeperator) + "    This configuration file was written by the eclipse-cs plugin configuration editor" + lineSeperator;
            doc.addComment(comment);
            String description = String.valueOf(lineSeperator) + "    Checkstyle-Configuration: " + checkConfig.getName() + lineSeperator + "    Description: " + (Strings.emptyToNull((String)checkConfig.getDescription()) != null ? String.valueOf(lineSeperator) + checkConfig.getDescription() + lineSeperator : "none" + lineSeperator);
            doc.addComment(description);
            List<Module> rootModules = ConfigurationWriter.getChildModules(null, modules);
            if (rootModules.size() < 1) {
                throw new CheckstylePluginException(Messages.errorNoRootModule);
            }
            if (rootModules.size() > 1) {
                throw new CheckstylePluginException(Messages.errorMoreThanOneRootModule);
            }
            ConfigurationWriter.writeModule(rootModules.get(0), (Branch)doc, null, modules);
            out.write(XMLUtil.toByteArray(doc));
        }
        catch (IOException ex) {
            CheckstylePluginException.rethrow(ex);
        }
    }

    private static void writeModule(Module module, Branch parent, Severity parentSeverity, List<Module> remainingModules) {
        Element metaEl;
        Severity severity = parentSeverity;
        remainingModules.remove(module);
        List<Module> childs = ConfigurationWriter.getChildModules(module, remainingModules);
        Element moduleEl = parent.addElement("module");
        moduleEl.addAttribute("name", module.getMetaData().getInternalName());
        if (Strings.emptyToNull((String)module.getComment()) != null) {
            Element element = moduleEl.addElement("metadata");
            element.addAttribute("name", "net.sf.eclipsecs.core.comment");
            element.addAttribute("value", module.getComment());
        }
        if (module.getSeverity() != null && !Severity.inherit.equals((Object)module.getSeverity())) {
            Element element = moduleEl.addElement("property");
            element.addAttribute("name", "severity");
            element.addAttribute("value", module.getSeverity().name());
            severity = module.getSeverity();
        }
        if (Strings.emptyToNull((String)module.getId()) != null) {
            Element element = moduleEl.addElement("property");
            element.addAttribute("name", "id");
            element.addAttribute("value", module.getId());
        }
        for (ConfigProperty configProperty : module.getProperties()) {
            String value = Strings.emptyToNull((String)configProperty.getValue());
            if (value == null || Objects.equals(value, configProperty.getMetaData().getDefaultValue())) continue;
            Element propertyEl2 = moduleEl.addElement("property");
            propertyEl2.addAttribute("name", configProperty.getMetaData().getName());
            propertyEl2.addAttribute("value", configProperty.getValue());
        }
        for (Map.Entry entry : module.getCustomMessages().entrySet()) {
            metaEl = moduleEl.addElement("message");
            metaEl.addAttribute("key", (String)entry.getKey());
            metaEl.addAttribute("value", (String)entry.getValue());
        }
        for (Map.Entry entry : module.getCustomMetaData().entrySet()) {
            metaEl = moduleEl.addElement("metadata");
            metaEl.addAttribute("name", (String)entry.getKey());
            metaEl.addAttribute("value", (String)entry.getValue());
        }
        if (module.getLastEnabledSeverity() != null) {
            Element element = moduleEl.addElement("metadata");
            element.addAttribute("name", "net.sf.eclipsecs.core.lastEnabledSeverity");
            element.addAttribute("value", module.getLastEnabledSeverity().name());
        }
        for (Module module2 : childs) {
            ConfigurationWriter.writeModule(module2, (Branch)moduleEl, severity, remainingModules);
        }
    }

    private static List<Module> getChildModules(Module module, List<Module> remainingModules) {
        ArrayList<Module> childModules = new ArrayList<Module>();
        for (Module tmp : remainingModules) {
            String parentInternalName = module != null ? module.getMetaData().getInternalName() : null;
            String childParent = tmp.getMetaData().getParentModule();
            if (parentInternalName == null && childParent.equals("Root")) {
                childModules.add(tmp);
                continue;
            }
            if (!childParent.equals(parentInternalName)) continue;
            childModules.add(tmp);
        }
        return childModules;
    }
}

