/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationType;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;

public class RemoteConfigurationType
extends ConfigurationType {
    public static final String KEY_CACHE_CONFIG = "cache-file";
    public static final String KEY_CACHE_FILE_LOCATION = "cache-file-location";
    public static final String KEY_CACHE_PROPS_FILE_LOCATION = "cache-props-file-location";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_MAX_REDIRECTS = "http.maxRedirects";
    private static Set<String> sFailedWith401URLs = new HashSet<String>();

    /*
     * Loose catch block
     */
    @Override
    public CheckstyleConfigurationFile getCheckstyleConfiguration(ICheckConfiguration checkConfiguration) throws CheckstylePluginException {
        CheckstyleConfigurationFile data;
        block21: {
            boolean useCacheFile = Boolean.parseBoolean(checkConfiguration.getAdditionalData().get(KEY_CACHE_CONFIG));
            data = new CheckstyleConfigurationFile();
            String currentRedirects = System.getProperty(KEY_MAX_REDIRECTS);
            try {
                try {
                    data.setResolvedConfigFileURL(this.resolveLocation(checkConfiguration));
                    boolean originalFileSuccess = false;
                    byte[] configurationFileData = null;
                    try {
                        System.setProperty(KEY_MAX_REDIRECTS, "3");
                        URLConnection connection = data.getResolvedConfigFileURL().openConnection();
                        RemoteConfigAuthenticator auth = RemoteConfigAuthenticator.create(data.getResolvedConfigFileURL());
                        if (auth != null) {
                            connection.setRequestProperty("Authorization", auth.basicAuthHeaderValue);
                        }
                        configurationFileData = this.getBytesFromURLConnection(connection);
                        data.setModificationStamp(connection.getLastModified());
                        originalFileSuccess = true;
                    }
                    catch (IOException exception) {
                        if (useCacheFile) {
                            configurationFileData = this.getBytesFromCacheFile(checkConfiguration);
                        }
                        throw exception;
                    }
                    data.setCheckConfigFileBytes(configurationFileData);
                    byte[] additionalPropertiesBytes = null;
                    if (originalFileSuccess) {
                        additionalPropertiesBytes = this.getAdditionPropertiesBundleBytes(data.getResolvedConfigFileURL());
                    } else if (useCacheFile) {
                        additionalPropertiesBytes = this.getBytesFromCacheBundleFile(checkConfiguration);
                    }
                    data.setAdditionalPropertyBundleBytes(additionalPropertiesBytes);
                    PropertyResolver resolver = this.getPropertyResolver(checkConfiguration, data);
                    data.setPropertyResolver(resolver);
                    if (originalFileSuccess && useCacheFile) {
                        this.writeToCacheFile(checkConfiguration, configurationFileData, additionalPropertiesBytes);
                    }
                }
                catch (UnknownHostException exception) {
                    CheckstylePluginException.rethrow(exception, NLS.bind((String)Messages.RemoteConfigurationType_errorUnknownHost, (Object)exception.getMessage()));
                    if (currentRedirects != null) {
                        System.setProperty(KEY_MAX_REDIRECTS, currentRedirects);
                    } else {
                        System.getProperties().remove(KEY_MAX_REDIRECTS);
                    }
                }
                catch (FileNotFoundException exception) {
                    block22: {
                        CheckstylePluginException.rethrow(exception, NLS.bind((String)Messages.RemoteConfigurationType_errorFileNotFound, (Object)exception.getMessage()));
                        if (currentRedirects == null) break block22;
                        System.setProperty(KEY_MAX_REDIRECTS, currentRedirects);
                        break block21;
                    }
                    System.getProperties().remove(KEY_MAX_REDIRECTS);
                }
                catch (IOException | URISyntaxException exception) {
                    block23: {
                        CheckstylePluginException.rethrow(exception);
                        if (currentRedirects == null) break block23;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        System.setProperty(KEY_MAX_REDIRECTS, currentRedirects);
                        break block21;
                    }
                    System.getProperties().remove(KEY_MAX_REDIRECTS);
                }
            }
            finally {
                if (currentRedirects != null) {
                    System.setProperty(KEY_MAX_REDIRECTS, currentRedirects);
                } else {
                    System.getProperties().remove(KEY_MAX_REDIRECTS);
                }
            }
        }
        return data;
    }

    @Override
    protected URL resolveLocation(ICheckConfiguration checkConfiguration) throws IOException {
        return new URL(checkConfiguration.getLocation());
    }

    @Override
    public void notifyCheckConfigRemoved(ICheckConfiguration checkConfiguration) throws CheckstylePluginException {
        super.notifyCheckConfigRemoved(checkConfiguration);
        RemoteConfigAuthenticator.removeCachedAuthInfo(checkConfiguration.getResolvedConfigurationFileURL());
        boolean useCacheFile = Boolean.parseBoolean(checkConfiguration.getAdditionalData().get(KEY_CACHE_CONFIG));
        if (useCacheFile) {
            String cacheFileLocation = checkConfiguration.getAdditionalData().get(KEY_CACHE_FILE_LOCATION);
            IPath cacheFilePath = CheckstylePlugin.getDefault().getStateLocation();
            cacheFilePath = cacheFilePath.append(cacheFileLocation);
            File cacheFile = cacheFilePath.toFile();
            cacheFile.delete();
        }
    }

    private byte[] getBytesFromCacheFile(ICheckConfiguration checkConfig) throws IOException {
        String cacheFileLocation = checkConfig.getAdditionalData().get(KEY_CACHE_FILE_LOCATION);
        IPath cacheFilePath = CheckstylePlugin.getDefault().getStateLocation();
        cacheFilePath = cacheFilePath.append(cacheFileLocation);
        File cacheFile = cacheFilePath.toFile();
        URL configURL = cacheFile.toURI().toURL();
        URLConnection connection = configURL.openConnection();
        return this.getBytesFromURLConnection(connection);
    }

    private byte[] getBytesFromCacheBundleFile(ICheckConfiguration checkConfig) {
        String cacheFileLocation = checkConfig.getAdditionalData().get(KEY_CACHE_PROPS_FILE_LOCATION);
        if (cacheFileLocation == null) {
            return null;
        }
        try {
            IPath cacheFilePath = CheckstylePlugin.getDefault().getStateLocation();
            cacheFilePath = cacheFilePath.append(cacheFileLocation);
            File cacheFile = cacheFilePath.toFile();
            URL configURL = cacheFile.toURI().toURL();
            URLConnection connection = configURL.openConnection();
            return this.getBytesFromURLConnection(connection);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void writeToCacheFile(ICheckConfiguration checkConfig, byte[] configFileBytes, byte[] bundleBytes) {
        String cacheFileLocation = checkConfig.getAdditionalData().get(KEY_CACHE_FILE_LOCATION);
        IPath cacheFilePath = CheckstylePlugin.getDefault().getStateLocation();
        cacheFilePath = cacheFilePath.append(cacheFileLocation);
        File cacheFile = cacheFilePath.toFile();
        try {
            Files.write((byte[])configFileBytes, (File)cacheFile);
        }
        catch (IOException ex) {
            CheckstyleLog.log(ex, NLS.bind((String)Messages.RemoteConfigurationType_msgRemoteCachingFailed, (Object)checkConfig.getName(), (Object)checkConfig.getLocation()));
        }
        if (bundleBytes != null) {
            String propsCacheFileLocation = checkConfig.getAdditionalData().get(KEY_CACHE_PROPS_FILE_LOCATION);
            IPath propsCacheFilePath = CheckstylePlugin.getDefault().getStateLocation();
            propsCacheFilePath = propsCacheFilePath.append(propsCacheFileLocation);
            File propsCacheFile = propsCacheFilePath.toFile();
            try {
                Files.write((byte[])bundleBytes, (File)propsCacheFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected byte[] getBytesFromURLConnection(URLConnection connection) throws IOException {
        byte[] configurationFileData = null;
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        if (connection instanceof HttpURLConnection) {
            if (!sFailedWith401URLs.contains(connection.getURL().toString())) {
                HttpURLConnection httpConn = (HttpURLConnection)connection;
                httpConn.setInstanceFollowRedirects(true);
                httpConn.connect();
                if (httpConn.getResponseCode() == 401) {
                    try {
                        RemoteConfigAuthenticator.removeCachedAuthInfo(connection.getURL());
                    }
                    catch (CheckstylePluginException ex) {
                        CheckstyleLog.log(ex);
                    }
                    sFailedWith401URLs.add(connection.getURL().toString());
                    throw new IOException(Messages.RemoteConfigurationType_msgUnAuthorized);
                }
            } else {
                throw new IOException(Messages.RemoteConfigurationType_msgUnAuthorized);
            }
        }
        Throwable throwable = null;
        Object var4_6 = null;
        try (InputStream in = connection.getInputStream();){
            configurationFileData = ByteStreams.toByteArray((InputStream)in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return configurationFileData;
    }

    public static final class RemoteConfigAuthenticator {
        private final String username;
        private final String password;
        private final String basicAuthHeaderValue;

        private RemoteConfigAuthenticator(String username, String password, String basicAuthHeaderValue) {
            this.username = username;
            this.password = password;
            this.basicAuthHeaderValue = basicAuthHeaderValue;
        }

        public static RemoteConfigAuthenticator create(URL resolvedCheckConfigurationUrl) {
            RemoteConfigAuthenticator auth = null;
            try {
                ISecurePreferences prefs = SecurePreferencesFactory.getDefault().node(RemoteConfigAuthenticator.getSecureStoragePath(resolvedCheckConfigurationUrl));
                String userName = prefs.get(RemoteConfigurationType.KEY_USERNAME, null);
                String password = prefs.get(RemoteConfigurationType.KEY_PASSWORD, null);
                if (userName != null && password != null) {
                    String unencodedHeader = String.valueOf(userName) + ":" + password;
                    String basicAuthHeaderValue = "Basic " + Base64.getEncoder().encodeToString(unencodedHeader.getBytes());
                    auth = new RemoteConfigAuthenticator(userName, password, basicAuthHeaderValue);
                }
            }
            catch (CheckstylePluginException | StorageException exception) {
                CheckstyleLog.log(exception);
            }
            return auth;
        }

        public static void storeCredentials(URL resolvedCheckConfigurationURL, String userName, String password) {
            try {
                ISecurePreferences prefs = SecurePreferencesFactory.getDefault().node(RemoteConfigAuthenticator.getSecureStoragePath(resolvedCheckConfigurationURL));
                prefs.put(RemoteConfigurationType.KEY_USERNAME, userName, false);
                prefs.put(RemoteConfigurationType.KEY_PASSWORD, password, true);
                sFailedWith401URLs.remove(resolvedCheckConfigurationURL.toString());
            }
            catch (CheckstylePluginException | StorageException ex) {
                CheckstyleLog.log(ex);
            }
        }

        public static void removeCachedAuthInfo(URL resolvedCheckConfigurationURL) throws CheckstylePluginException {
            sFailedWith401URLs.remove(resolvedCheckConfigurationURL.toString());
            String storagePath = RemoteConfigAuthenticator.getSecureStoragePath(resolvedCheckConfigurationURL);
            if (SecurePreferencesFactory.getDefault().nodeExists(storagePath)) {
                ISecurePreferences prefs = SecurePreferencesFactory.getDefault().node(RemoteConfigAuthenticator.getSecureStoragePath(resolvedCheckConfigurationURL));
                prefs.removeNode();
            }
        }

        private static String getSecureStoragePath(URL resolvedCheckConfigurationURL) throws CheckstylePluginException {
            String urlHash = null;
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] hash = digest.digest(resolvedCheckConfigurationURL.toExternalForm().getBytes("UTF-8"));
                urlHash = EncodingUtils.encodeBase64((byte[])hash);
                urlHash = urlHash.replace('/', '_');
                urlHash = urlHash.replace('\\', '_');
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
                CheckstylePluginException.rethrow(ex);
            }
            return "eclipse-cs/" + urlHash;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

