/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import com.puppycrawl.tools.checkstyle.PropertyResolver;
import net.sf.eclipsecs.core.config.configtypes.IContextAware;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class StandardPropertyResolver
implements PropertyResolver,
IContextAware {
    private static final String WORKSPACE_LOC = "workspace_loc";
    private static final String PROJECT_LOC = "project_loc";
    private static final String BASEDIR_LOC = "basedir";
    private static final String SAMEDIR_LOC = "samedir";
    private static final String CONFIG_LOC = "config_loc";
    private final String mConfigLocation;
    private IProject mProject;

    public StandardPropertyResolver(String configLocation) {
        this.mConfigLocation = configLocation;
    }

    @Override
    public void setProjectContext(IProject project) {
        this.mProject = project;
    }

    public String resolve(String property) {
        String configLocWOBackslashes;
        int lastSlash;
        String value = null;
        if (WORKSPACE_LOC.equals(property)) {
            value = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        } else if (this.mProject != null && (PROJECT_LOC.equals(property) || BASEDIR_LOC.equals(property))) {
            value = this.mProject.getLocation().toString();
        } else if (this.mConfigLocation != null && (SAMEDIR_LOC.equals(property) || CONFIG_LOC.equals(property)) && (lastSlash = (configLocWOBackslashes = this.mConfigLocation.replace('\\', '/')).lastIndexOf("/")) > -1) {
            value = configLocWOBackslashes.substring(0, lastSlash + 1);
        }
        return value;
    }
}

