/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.jobs;

import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.IContextAware;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.transformer.CheckstyleTransformer;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xml.sax.InputSource;

public class TransformCheckstyleRulesJob
extends WorkspaceJob {
    private IProject mProject;

    public TransformCheckstyleRulesJob(IProject project) {
        super("transformCheckstyle");
        this.mProject = project;
    }

    public IStatus runInWorkspace(IProgressMonitor arg0) throws CoreException {
        try {
            IProjectConfiguration conf = ProjectConfigurationFactory.getConfiguration(this.mProject);
            ArrayList<Configuration> rules = new ArrayList<Configuration>();
            for (FileSet fileSet : conf.getFileSets()) {
                ICheckConfiguration checkConfig = fileSet.getCheckConfig();
                CheckstyleConfigurationFile configFile = checkConfig.getCheckstyleConfiguration();
                PropertyResolver resolver = configFile.getPropertyResolver();
                if (resolver instanceof IContextAware) {
                    ((IContextAware)resolver).setProjectContext(this.mProject);
                }
                InputSource input = null;
                try {
                    input = configFile.getCheckConfigFileInputSource();
                    Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)input, (PropertyResolver)resolver, (ConfigurationLoader.IgnoredModulesOptions)ConfigurationLoader.IgnoredModulesOptions.OMIT);
                    TransformCheckstyleRulesJob.recurseConfiguration(configuration, rules);
                }
                finally {
                    Closeables.closeQuietly((InputStream)input.getByteStream());
                }
            }
            if (rules.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            CheckstyleTransformer transformer = new CheckstyleTransformer(this.mProject, rules);
            transformer.transformRules();
        }
        catch (CheckstyleException | CheckstylePluginException ex) {
            Status status = new Status(4, "net.sf.eclipsecs.core", 4, ex.getMessage(), ex);
            throw new CoreException((IStatus)status);
        }
        return Status.OK_STATUS;
    }

    private static void recurseConfiguration(Configuration module, List<Configuration> flatModules) {
        flatModules.add(module);
        Configuration[] childs = module.getChildren();
        if (childs != null && childs.length > 0) {
            Configuration[] configurationArray = childs;
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration child = configurationArray[n2];
                TransformCheckstyleRulesJob.recurseConfiguration(child, flatModules);
                ++n2;
            }
        }
    }
}

