/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.jobs;

import java.io.FileNotFoundException;
import net.sf.eclipsecs.core.transformer.FormatterConfigParser;
import net.sf.eclipsecs.core.transformer.FormatterConfiguration;
import net.sf.eclipsecs.core.transformer.FormatterTransformer;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TransformFormatterRulesJob
extends WorkspaceJob {
    public TransformFormatterRulesJob() {
        super("transformFormatter");
    }

    public IStatus runInWorkspace(IProgressMonitor arg0) throws CoreException {
        String workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        String configLocation = String.valueOf(workspace) + "/.metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.jdt.core.prefs";
        FormatterConfigParser parser = null;
        try {
            parser = new FormatterConfigParser(configLocation);
        }
        catch (FileNotFoundException ex) {
            return Status.CANCEL_STATUS;
        }
        FormatterConfiguration rules = parser.parseRules();
        if (rules == null) {
            return Status.CANCEL_STATUS;
        }
        try {
            FormatterTransformer transformer = new FormatterTransformer(rules);
            transformer.transformRules(String.valueOf(workspace) + "/test-checkstyle.xml");
        }
        catch (CheckstylePluginException ex) {
            Status status = new Status(4, "net.sf.eclipsecs.core", 4, ex.getMessage(), (Throwable)ex);
            throw new CoreException((IStatus)status);
        }
        return Status.OK_STATUS;
    }
}

