/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.util.CheckstylePluginException;

public class FileMatchPattern
implements Cloneable {
    private boolean mIsIncludePattern = true;
    private Pattern mRegexPattern;
    private String mPatternString;

    public FileMatchPattern(String pattern) throws CheckstylePluginException {
        this.setMatchPattern(pattern);
    }

    public String getMatchPattern() {
        return this.mRegexPattern.pattern();
    }

    public void setMatchPattern(String pattern) throws CheckstylePluginException {
        if (pattern == null || pattern.trim().length() == 0) {
            throw new CheckstylePluginException(Messages.errorEmptyPattern);
        }
        try {
            this.mRegexPattern = Pattern.compile(pattern);
            this.mPatternString = pattern;
        }
        catch (PatternSyntaxException ex) {
            CheckstylePluginException.rethrow(ex);
        }
    }

    public boolean isMatch(String fileName) {
        boolean result = false;
        Matcher matcher = this.mRegexPattern.matcher(fileName);
        result = matcher.find();
        return result;
    }

    public boolean isIncludePattern() {
        return this.mIsIncludePattern;
    }

    public void setIsIncludePattern(boolean isIncludePattern) {
        this.mIsIncludePattern = isIncludePattern;
    }

    public FileMatchPattern clone() {
        try {
            return (FileMatchPattern)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FileMatchPattern)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FileMatchPattern rhs = (FileMatchPattern)obj;
        return Objects.equals(this.mIsIncludePattern, rhs.mIsIncludePattern) && Objects.equals(this.mPatternString, rhs.mPatternString);
    }

    public int hashCode() {
        return Objects.hash(this.mIsIncludePattern, this.mPatternString);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("patternString", (Object)this.mPatternString).add("isIncludePattern", this.mIsIncludePattern).toString();
    }
}

