/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.PluginFilters;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import org.eclipse.core.resources.IProject;

public class ProjectConfiguration
implements Cloneable,
IProjectConfiguration {
    private IProject mProject;
    private List<ICheckConfiguration> mLocalCheckConfigs;
    private List<FileSet> mFileSets;
    private List<IFilter> mFilters;
    private boolean mUseSimpleConfig = true;
    private boolean mSyncFormatter;

    public ProjectConfiguration(IProject project, List<ICheckConfiguration> localConfigs, List<FileSet> fileSets, List<IFilter> filters, boolean useSimpleConfig, boolean synchFormatter) {
        this.mProject = project;
        this.mLocalCheckConfigs = localConfigs != null ? Collections.unmodifiableList(localConfigs) : Collections.unmodifiableList(new ArrayList());
        this.mFileSets = fileSets != null ? Collections.unmodifiableList(fileSets) : Collections.unmodifiableList(new ArrayList());
        List<IFilter> standardFilters = Arrays.asList(PluginFilters.getConfiguredFilters());
        this.mFilters = new ArrayList<IFilter>(standardFilters);
        if (filters != null) {
            int i = 0;
            int size = this.mFilters.size();
            while (i < size) {
                IFilter standardFilter = this.mFilters.get(i);
                int j = 0;
                int size2 = filters.size();
                while (j < size2) {
                    IFilter configuredFilter = filters.get(j);
                    if (standardFilter.getInternalName().equals(configuredFilter.getInternalName())) {
                        this.mFilters.set(i, configuredFilter);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.mFilters = Collections.unmodifiableList(this.mFilters);
        this.mUseSimpleConfig = useSimpleConfig;
        this.mSyncFormatter = synchFormatter;
    }

    @Override
    public IProject getProject() {
        return this.mProject;
    }

    public List<ICheckConfiguration> getLocalCheckConfigurations() {
        return this.mLocalCheckConfigs;
    }

    @Override
    public List<FileSet> getFileSets() {
        return this.mFileSets;
    }

    @Override
    public List<IFilter> getFilters() {
        return this.mFilters;
    }

    @Override
    public boolean isUseSimpleConfig() {
        return this.mUseSimpleConfig;
    }

    @Override
    public boolean isSyncFormatter() {
        return this.mSyncFormatter;
    }

    @Override
    public boolean isConfigInUse(ICheckConfiguration configuration) {
        boolean result = false;
        for (FileSet fileSet : this.getFileSets()) {
            ICheckConfiguration checkConfig = fileSet.getCheckConfig();
            if (!configuration.equals(checkConfig) && (!(checkConfig instanceof CheckConfigurationWorkingCopy) || !configuration.equals(((CheckConfigurationWorkingCopy)checkConfig).getSourceCheckConfiguration()))) continue;
            result = true;
            break;
        }
        return result;
    }

    public ProjectConfiguration clone() {
        ProjectConfiguration clone = null;
        try {
            clone = (ProjectConfiguration)super.clone();
            clone.mFileSets = new LinkedList<FileSet>();
            clone.mUseSimpleConfig = this.mUseSimpleConfig;
            clone.mSyncFormatter = this.mSyncFormatter;
            ArrayList<FileSet> clonedFileSets = new ArrayList<FileSet>();
            for (FileSet fileSet : this.getFileSets()) {
                clonedFileSets.add(fileSet.clone());
            }
            clone.mFileSets = clonedFileSets;
            ArrayList<IFilter> clonedFilters = new ArrayList<IFilter>();
            for (IFilter filter : this.getFilters()) {
                clonedFilters.add(filter.clone());
            }
            clone.mFilters = clonedFilters;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProjectConfiguration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ProjectConfiguration rhs = (ProjectConfiguration)obj;
        return Objects.equals(this.mProject, rhs.mProject) && Objects.equals(this.mLocalCheckConfigs, rhs.mLocalCheckConfigs) && Objects.equals(this.mUseSimpleConfig, rhs.mUseSimpleConfig) && Objects.equals(this.mSyncFormatter, rhs.mSyncFormatter) && Objects.equals(this.mFileSets, rhs.mFileSets) && Objects.equals(this.mFilters, rhs.mFilters);
    }

    public int hashCode() {
        return Objects.hash(this.mProject, this.mLocalCheckConfigs, this.mUseSimpleConfig, this.mSyncFormatter, this.mFileSets, this.mFilters);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("project", (Object)this.mProject).add("localCheckConfigs", this.mLocalCheckConfigs).add("useSimpleConfig", this.mUseSimpleConfig).add("syncFormatter", this.mSyncFormatter).add("fileSets", this.mFileSets).add("filters", this.mFilters).toString();
    }
}

