/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig.filters;

import net.sf.eclipsecs.core.projectconfig.filters.AbstractFilter;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;

public class FilesInSyncFilter
extends AbstractFilter {
    @Override
    public boolean accept(Object element) {
        Subscriber subscriber;
        RepositoryProvider provider;
        IFile file;
        IProject project;
        boolean passes = true;
        if (element instanceof IFile && RepositoryProvider.isShared((IProject)(project = (file = (IFile)element).getProject())) && (provider = RepositoryProvider.getProvider((IProject)project)) != null && (subscriber = provider.getSubscriber()) != null) {
            passes = this.hasChanges(file, subscriber);
        }
        return passes;
    }

    private boolean hasChanges(IFile file, Subscriber subscriber) {
        boolean hasChanges = false;
        try {
            SyncInfo synchInfo = subscriber.getSyncInfo((IResource)file);
            if (synchInfo != null) {
                int kind = synchInfo.getKind();
                hasChanges = (SyncInfo.getDirection((int)kind) & 4) == 4;
            }
        }
        catch (TeamException ex) {
            CheckstyleLog.log(ex);
        }
        return hasChanges;
    }
}

