/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.transformer;

import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.eclipsecs.core.transformer.FormatterConfiguration;
import net.sf.eclipsecs.core.transformer.XmlProfileWriter;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class FormatterConfigWriter {
    private static final String CS_GENERATED = "CheckStyle-Generated ";
    private final FormatterConfiguration mConfiguration;
    private IProject mProject;

    public FormatterConfigWriter(IProject project, FormatterConfiguration settings) {
        this.mConfiguration = settings;
        this.mProject = project;
        this.writeSettings();
    }

    private void writeSettings() {
        this.writeCleanupSettings(this.mConfiguration.getCleanupSettings());
        this.writeFormatterSettings(this.mConfiguration.getFormatterSettings());
    }

    private void writeCleanupSettings(Map<String, String> settings) {
        IFile settingsFile = this.mProject.getFile(String.valueOf(this.mProject.getName()) + "-cs-cleanup.xml");
        try {
            InputStream stream = XmlProfileWriter.writeCleanupProfileToStream(CS_GENERATED + this.mProject.getName(), settings);
            FormatterConfigWriter.createOrUpdateFile(settingsFile, stream);
        }
        catch (ParserConfigurationException | TransformerException | CoreException exc) {
            CheckstyleLog.log(exc, "Error saving cleanup profile");
        }
    }

    private void writeFormatterSettings(Map<String, String> settings) {
        IFile settingsFile = this.mProject.getFile(String.valueOf(this.mProject.getName()) + "-cs-formatter.xml");
        try {
            InputStream stream = XmlProfileWriter.writeFormatterProfileToStream(CS_GENERATED + this.mProject.getName(), settings);
            FormatterConfigWriter.createOrUpdateFile(settingsFile, stream);
        }
        catch (ParserConfigurationException | TransformerException | CoreException exc) {
            CheckstyleLog.log(exc, "Error saving formatter profile");
        }
    }

    private static void createOrUpdateFile(IFile settingsFile, InputStream stream) throws CoreException {
        if (settingsFile.exists()) {
            settingsFile.setContents(stream, true, false, null);
        } else {
            settingsFile.create(stream, true, null);
        }
    }
}

