/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.transformer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.transformer.CheckstyleFileWriter;
import net.sf.eclipsecs.core.transformer.CheckstyleSetting;
import net.sf.eclipsecs.core.transformer.FTransformationClass;
import net.sf.eclipsecs.core.transformer.FormatterConfiguration;
import net.sf.eclipsecs.core.util.CheckstylePluginException;

public class FormatterTransformer {
    private final CheckstyleSetting mCheckstyleSetting = new CheckstyleSetting();
    private final List<FTransformationClass> mTransformationClasses = new ArrayList<FTransformationClass>();
    private FormatterConfiguration mFormatterSetting = new FormatterConfiguration();

    public FormatterTransformer(FormatterConfiguration rules) throws CheckstylePluginException {
        this.mFormatterSetting = rules;
        ArrayList<String> classnames = new ArrayList<String>();
        for (String help : this.mFormatterSetting.getFormatterSettings().keySet()) {
            String[] tokens = help.split("\\.");
            String className = "net.sf.eclipsecs.core.transformer.ftransformerclasses.T";
            int i = 5;
            while (i < tokens.length) {
                className = String.valueOf(className) + "_" + tokens[i];
                ++i;
            }
            classnames.add(className);
        }
        this.loadTransformationClasses(classnames);
    }

    private void loadTransformationClasses(List<String> classnames) throws CheckstylePluginException {
        Iterator<String> nameit = classnames.iterator();
        Iterator<String> ruleit = this.mFormatterSetting.getFormatterSettings().keySet().iterator();
        while (nameit.hasNext() && ruleit.hasNext()) {
            String name = nameit.next();
            String rule = ruleit.next();
            try {
                Class<?> transformationClass = CheckstylePlugin.getDefault().getAddonExtensionClassLoader().loadClass(name);
                FTransformationClass transObj = (FTransformationClass)transformationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                transObj.setValue(this.mFormatterSetting.getFormatterSettings().get(rule));
                this.mTransformationClasses.add(transObj);
            }
            catch (ClassNotFoundException transObj) {
            }
            catch (ReflectiveOperationException ex) {
                CheckstylePluginException.rethrow(ex);
            }
        }
    }

    public void transformRules(String path) {
        this.loadRuleConfigurations();
        new CheckstyleFileWriter(this.mCheckstyleSetting, path);
    }

    private void loadRuleConfigurations() {
        Iterator<FTransformationClass> it = this.mTransformationClasses.iterator();
        while (it.hasNext()) {
            CheckstyleSetting settings = it.next().transformRule();
            this.mCheckstyleSetting.addSetting(settings);
        }
    }
}

