/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.transformer.ctransformerclasses;

import java.util.StringTokenizer;
import net.sf.eclipsecs.core.transformer.CTransformationClass;
import net.sf.eclipsecs.core.transformer.FormatterConfiguration;

public class LeftCurlyTransformer
extends CTransformationClass {
    @Override
    public FormatterConfiguration transformRule() {
        String tokens = this.getAttribute("tokens");
        if (tokens == null) {
            tokens = "CLASS_DEF, CTOR_DEF, INTERFACE_DEF, METHOD_DEF, LITERAL_CATCH, LITERAL_DO, LITERAL_ELSE, LITERAL_FINALLY, LITERAL_FOR, LITERAL_IF, LITERAL_SYNCHRONIZED, LITERAL_TRY, LITERAL_WHILE";
        }
        StringTokenizer token = new StringTokenizer(tokens, ", ");
        String option = this.getAttribute("option");
        if (option == null) {
            option = "eol";
        }
        if (option.equals("eol")) {
            option = "end_of_line";
        } else if (option.equals("nl") || option.equals("nlow")) {
            option = "next_line";
        }
        while (token.hasMoreTokens()) {
            String tok = token.nextToken();
            if (tok.equals("CLASS_DEF")) {
                this.userFormatterSetting("brace_position_for_anonymous_type_declaration", option);
                this.userFormatterSetting("brace_position_for_enum_constant", option);
                this.userFormatterSetting("brace_position_for_enum_declaration", option);
                this.userFormatterSetting("brace_position_for_type_declaration", option);
                this.userFormatterSetting("brace_position_for_annotation_type_declaration", option);
                continue;
            }
            if (tok.equals("INTERFACE_DEF")) {
                this.userFormatterSetting("brace_position_for_annotation_type_declaration", option);
                this.userFormatterSetting("brace_position_for_type_declaration", option);
                continue;
            }
            if (tok.equals("CTOR_DEF")) {
                this.userFormatterSetting("brace_position_for_constructor_declaration", option);
                continue;
            }
            if (tok.equals("METHOD_DEF")) {
                this.userFormatterSetting("brace_position_for_method_declaration", option);
                continue;
            }
            if (tok.equals("LITERAL_DO") || tok.equals("LITERAL_ELSE") || tok.equals("LITERAL_FOR") || tok.equals("LITERAL_IF") || tok.equals("LITERAL_WHILE") || tok.equals("LITERAL_CATCH") || tok.equals("LITERAL_FINALLY") || tok.equals("LITERAL_TRY")) {
                this.userFormatterSetting("brace_position_for_block", option);
                continue;
            }
            if (!tok.equals("LITERAL_SWITCH")) continue;
            this.userFormatterSetting("brace_position_for_switch", option);
        }
        return this.getFormatterSetting();
    }
}

